//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MJF 07/05/89 -- Initial design and implementation.
// Updated: LGO 09/20/89 -- Split into separate file.
// Updated: MJF 02/22/90 -- Changed raise() from friend to member function.

// An overview of the structure of the Exception class, the Excp_Handler class
// and the exception mechanism for creating, raising and handling an exception
// can be found in the Exception.h header file.

#include <cool/Exception.h>	// include the Exception header file.
#include <cool/Generic.h>	// include the Generic header file.

// *********************************************************************
// Member function of the Exception Class
// *********************************************************************

// Exception* void Exception::raise() -- Searches for an Exception Handler
//                            which handles the specified Exception and if
//                            found invokes its handler function.  This
//                            function returns if the handler invoked returns.
//                            The exception object contains a flag which is set
//                            by a handler to indicate that the exception was
//                            handled.
//
// Input:  None
// Output: This exception object raised.

Exception* Exception::raise() {
  // search for an Exception Handler and invoke it if found
  for (Excp_Handler* ehp = Excp_Handler::top_handler;
       ehp != NULL && ehp->invoke_handler(this) == FALSE;
       ehp = ehp->next_handler);
  // call default_handler function if no handlers handled this exception
  if (!this->is_handled()) this->default_handler();  
  return this;
}
