//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MJF 07/05/89 -- Initial design and implementation.
// Updated: MJF 02/22/90 -- Added match() member functions.

// An overview of the structure of the Exception class, the Excp_Handler class
// and the exception mechanism for creating, raising and handling an exception
// can be found in the Exception.h header file.

#include <cool/Exception.h>	// include the Exception header file.
#include <cool/Generic.h>	// include the Generic header file.

// ************************************************************************
// Member functions for Exception class
// ************************************************************************

// Exception::match(Excp_Type) - returns true if this exception is of the
//                               specified exception type or
//                               if the specified excpetion type is a member 
//                               of this exception's group name array.
//
// Input:   An Exception type.
// Output:  True/False.

Boolean Exception::match(Excp_Type e) {
#if GENERIC_TYPECHECK				// If symbols available
  return (this->is_type_of(e) || this->is_group_member(e));
#else
  return (this->is_group_member(e));
#endif
}

// Exception::match(Excp_Type*) - returns true if this exception is 
//                                the same type as one of the specified 
//                                exception types or if one of the specified
//                                excpetion types is a member of this exception
//                                group name array.
//
// Input:   True/False
// Output:  None.

Boolean Exception::match(Excp_Type* etypes) {
#if GENERIC_TYPECHECK				// If symbols available
  return ((this->select_type_of(etypes) >= 0) ||
	  this->is_group_member(etypes));
#else
  return (this->is_group_member(etypes));
#endif
}

Boolean Exception::is_group_member(Excp_Type gtype) {
  if (this->group_names == NULL || gtype == NULL) return FALSE;
  Excp_Type* gn = this->group_names;
  while (*gn != NULL) if (*gn++ == gtype) return TRUE;
  return FALSE;
}

Boolean Exception::is_group_member(Excp_Type* gtypes) {
  if (this->group_names == NULL || gtypes == NULL) return FALSE;
  Excp_Type* g = gtypes;
  while (*g != NULL) {
    if (this->is_group_member(*g++)) return TRUE;
  }
  return FALSE;
}
