//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//

#include <cool/String.h>
#include <cool/Association.h>
#include <test.h>

DECLARE Association<int,double>;
IMPLEMENT Association<int,double>;
DECLARE Association<int,char*>;
IMPLEMENT Association<int,char*>;
DECLARE Association<int,String>;
IMPLEMENT Association<int,String>;

Boolean my_compare_charP (const charP& s1, const charP& s2) {
  return (strcmp (s1, s2) ? FALSE : TRUE);
}

void test_int_charP () {
  int key;
  char* value;

  Association<int,char*> a0;
  TEST("Association<int,char*> a0", 1, 1);
  TEST ("a0.length()", a0.length(), 0);
  TEST ("a0.capacity()", a0.capacity(), 0);
  Association<int,char*> a1(5);
  TEST("Association<int,char*> a1(5)", 1, 1);
  TEST ("a1.length()", a1.length(), 0);
  TEST ("a1.capacity()", a1.capacity(), 5);
  a1.set_value_compare(&my_compare_charP);
  TEST ("a1.set_value_compare(&my_compare_charP)",1,1);
  Association<int,char*> a2(10);
  TEST ("Association<int,char*> a2(10)",1,1);
  TEST ("a2.capacity()",a2.capacity(),10);
  TEST ("a2.put(1,\"AAA\")",a2.put(1,"AAA"), TRUE);
  TEST ("a2.put(2,\"BBB\")",a2.put(2,"BBB"), TRUE);
  TEST ("a2.put(3,\"CCC\")",a2.put(3,"CCC"), TRUE);
  TEST ("a2.put(4,\"DDD\")",a2.put(4,"DDD"), TRUE);
  TEST ("a2.length()", a2.length(), 4);
  TEST ("a2.capacity()", a2.capacity(), 10);
  Association<int,char*> a3 = a2;
  TEST("Association<int,char*> a3 = a2", 1, 1);
  TEST ("a3.length()", a3.length(), 4);
  TEST ("a3.capacity()", a3.capacity(), 10);
  TEST ("a2 == a3", a2 == a3, TRUE);
  TEST("a3 != a1", (a3 != a1), TRUE);
  TEST("a3 = a1", (a3 = a1), a1);
  TEST("a2.find(3)", a2.find(3), TRUE);
  TEST("a2.value()", (strcmp (a2.value(),"CCC")), 0);
  TEST("a2.prev()", (a2.prev() && !strcmp(a2.value(),"BBB")), TRUE);
  TEST("a2.key()", a2.key(), 2);
  TEST("a2.next()", (a2.next() && !strcmp(a2.value(),"CCC")), TRUE);
  TEST("a2.get(1, value)", (a2.get(1, value) && !strcmp(value,"AAA")), TRUE);
  TEST("a2.get_key(\"DDD\", key)", (a2.get_key("DDD", key) && key==4), TRUE);
  TEST("a2.length()", a2.length(), 4);
  TEST("a2.put(5,\"EEE\")", (a2.put(5,"EEE") && a2.length() == 5), TRUE);
  a2.reset();
  TEST("a2.reset()", a2.prev(), TRUE);
  TEST("a2.find(2)", a2.find(2), TRUE);
  TEST("a2.remove()", strcmp (a2.remove(),"BBB"),0);
  TEST("a2.remove(4)", a2.remove(4), TRUE);
  a1.resize(10);
  TEST("a1.resize(10)", 1, 1);
  a0.set_length(2);
  TEST("a0.set_length(2)", 1, 1);
  a3.set_growth_ratio(2.0);
  TEST("a3.set_growth_ratio", 1, 1);
}

void test_int_double () {
  double a = 1.0;
  double b = 2.0;
  double c = 3.0;
  double d = 4.0;
  double e = 5.0;
 
  int key;
  double value;

  Association<int,double> a0;
  TEST("Association<int,double> a0", 1, 1);
  TEST ("a0.length()", a0.length(), 0);
  TEST ("a0.capacity()", a0.capacity(), 0);
  Association<int,double> a1(5);
  TEST("Association<int,double> a1(5)", 1, 1);
  TEST ("a1.length()", a1.length(), 0);
  TEST ("a1.capacity()", a1.capacity(), 5);
  Association<int,double> a2(10);
  TEST ("Association<int,double> a2(10)",1,1);
  TEST ("a2.capacity()",a2.capacity(),10);
  TEST ("a2.put(1,1.0)",a2.put(1,1.0), TRUE);
  TEST ("a2.put(2,2.0)",a2.put(2,2.0), TRUE);
  TEST ("a2.put(3,3.0)",a2.put(3,3.0), TRUE);
  TEST ("a2.put(4,4.0)",a2.put(4,4.0), TRUE);
  TEST ("a2.length()", a2.length(), 4);
  TEST ("a2.capacity()", a2.capacity(), 10);
  Association<int,double> a3 = a2;
  TEST("Association<int,double> a3 = a2", 1, 1);
  TEST ("a3.length()", a3.length(), 4);
  TEST ("a3.capacity()", a3.capacity(), 10);
  TEST ("a2 == a3", a2 == a3, TRUE);
  TEST("a3 != a1", (a3 != a1), TRUE);
  TEST("a3 = a1", (a3 = a1), a1);
  TEST("a2.find(3)", a2.find(3), TRUE);
  TEST("a2.value()", (a2.value() == c), TRUE);
  TEST("a2.prev()", (a2.prev() && a2.value() == b), TRUE);
  TEST("a2.key()", a2.key(), 2);
  TEST("a2.next()", (a2.next() && a2.value() == c), TRUE);
  TEST("a2.get(1, value)", (a2.get(1, value) && value==a), TRUE);
  TEST("a2.get_key(d, key)", (a2.get_key(d, key) && key==4), TRUE);
  TEST("a2.length()", a2.length(), 4);
  TEST("a2.put(5,e)", (a2.put(5,e) && a2.length() == 5), TRUE);
  a2.reset();
  TEST("a2.reset()", a2.prev(), TRUE);
  TEST("a2.find(2)", a2.find(2), TRUE);
  TEST("a2.remove()", a2.remove(), b);
  TEST("a2.remove(4)", a2.remove(4), TRUE);
  a1.resize(10);
  TEST("a1.resize(10)", 1, 1);
  a0.set_length(2);
  TEST("a0.set_length(2)", 1, 1);
  a3.set_growth_ratio(2.0);
  TEST("a3.set_growth_ratio", 1, 1);
}

void test_int_String () {
  String a = "AAA";
  String b = "BBB";
  String c = "CCC";
  String d = "DDD";
  String e = "EEE";
 
  int key;
  String value;

  Association<int,String> a0;
  TEST("Association<int,String> a0", 1, 1);
  TEST ("a0.length()", a0.length(), 0);
  TEST ("a0.capacity()", a0.capacity(), 0);
  Association<int,String> a1(5);
  TEST("Association<int,String> a1(5)", 1, 1);
  TEST ("a1.length()", a1.length(), 0);
  TEST ("a1.capacity()", a1.capacity(), 5);
  Association<int,String> a2(10);
  TEST ("Association<int,String> a2(10)",1,1);
  TEST ("a2.capacity()",a2.capacity(),10);
  TEST ("a2.put(1,String(\"AAA\"))",a2.put(1,String("AAA")), TRUE);
  TEST ("a2.put(2,String(\"BBB\"))",a2.put(2,String("BBB")), TRUE);
  TEST ("a2.put(3,String(\"CCC\"))",a2.put(3,String("CCC")), TRUE);
  TEST ("a2.put(4,String(\"DDD\"))",a2.put(4,String("DDD")), TRUE);
  TEST ("a2.length()", a2.length(), 4);
  TEST ("a2.capacity()", a2.capacity(), 10);
  Association<int,String> a3 = a2;
  TEST("Association<int,String> a3 = a2", 1, 1);
  TEST ("a3.length()", a3.length(), 4);
  TEST ("a3.capacity()", a3.capacity(), 10);
  TEST ("a2 == a3", a2 == a3, TRUE);
  TEST("a3 != a1", (a3 != a1), TRUE);
  TEST("a3 = a1", (a3 = a1), a1);
  TEST("a2.find(3)", a2.find(3), TRUE);
  TEST("a2.value()", (a2.value() == c), TRUE);
  TEST("a2.prev()", (a2.prev() && a2.value() == b), TRUE);
  TEST("a2.key()", a2.key(), 2);
  TEST("a2.next()", (a2.next() && a2.value() == c), TRUE);
  TEST("a2.get(1, value)", (a2.get(1, value) && value==a), TRUE);
  TEST("a2.get_key(d, key)", (a2.get_key(d, key) && key==4), TRUE);
  TEST("a2.length()", a2.length(), 4);
  TEST("a2.put(5,e)", (a2.put(5,e) && a2.length() == 5), TRUE);
  a2.reset();
  TEST("a2.reset()", a2.prev(), TRUE);
  TEST("a2.find(2)", a2.find(2), TRUE);
  TEST("a2.remove()", a2.remove(), b);
  TEST("a2.remove(4)", a2.remove(4), TRUE);
  a1.resize(10);
  TEST("a1.resize(10)", 1, 1);
  a0.set_length(2);
  TEST("a0.set_length(2)", 1, 1);
  a3.set_growth_ratio(2.0);
  TEST("a3.set_growth_ratio", 1, 1);
}

int main () {
  START("Association");
  test_int_double ();
  test_int_charP ();
  test_int_String ();
  SUMMARY();
  return 0;
}


