(* Copyright (C) 1989, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Wed Mar  4 08:31:11 PST 1992 by kalsow     *)
(*      modified on Sat Sep 15 02:51:50 1990 by muller         *)
(*      modified on Mon Sep  5 17:21:33 1988 by stolfi         *)
(*      modified on Fri Jun 10 14:20:12 1988 by glassman       *)

INTERFACE Params;

(* simple access to Unix command arguments.

   The Unix world has a particularly well-developed collection of
   conventions about parsing command lines.  The Params interface
   provides minimal facilities for accessing command-line parameters.
   For fancier facilities, see ParseParams.i3.

   Index: shell, command line switches; Unix, command line switches;
     command line parsing; parsing, command line;
     arguments, from command line; parameters, from command line;
     switches, from command line *)

VAR (* READONLY *) Count: CARDINAL;
(* Parameters are indexed from 0 (the command name) to Count-1. *)

PROCEDURE Get (n: CARDINAL): TEXT;
(* Fetches the parameter with index 'n'.  Returns NIL if n >= Count. *)

END Params.
