(* Copyright (C) 1989, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: M3LinkerRep.i3                                        *)
(* Last Modified On Wed Feb 12 10:25:25 PST 1992 By kalsow     *)

INTERFACE M3LinkerRep;

IMPORT Wr, M3Linker, M3LinkMap;

REVEAL
  M3Linker.LinkSet = BRANDED "M3Linker.LinkSet 1.0" REF LinkRec;

TYPE
  LinkRec = RECORD
    mode       : M3Linker.Mode := M3Linker.Mode.Units;
    all_units  : M3Linker.UnitList := NIL;
    interfaces : M3LinkMap.T := NIL;  (* interface name -> Unit        *)
    modules    : M3LinkMap.T := NIL;  (* module name -> Unit           *)
    types      : M3LinkMap.T := NIL;  (* type uid -> Type              *)
    stamps     : M3LinkMap.T := NIL;  (* symbol name -> VersionStamp   *)
    revelations: M3LinkMap.T := NIL;  (* interface name -> revel. list *)
    revealed   : REF ARRAY OF M3Linker.Type; (* type index -> revealed rhs *)
    refany     : M3Linker.Type := NIL;
    address    : M3Linker.Type := NIL;
    null       : M3Linker.Type := NIL;
    text       : M3Linker.Type := NIL;
    root       : M3Linker.Type := NIL;
    un_root    : M3Linker.Type := NIL;
    main       : M3Linker.Unit := NIL;
    builtin    : M3Linker.Unit := NIL;
  END;

TYPE
  RevelationList = REF RECORD
    unit     : M3Linker.Name;
    revealed : RevelationNode;
  END;
  RevelationNode = REF RECORD
    revelation : M3Linker.Revelation;
    next       : RevelationNode;
  END;

PROCEDURE TypeName ( t: M3Linker.Type): TEXT;
PROCEDURE UTypeName (t: M3Linker.UndefinedType): TEXT;
PROCEDURE UnitName  (u: M3Linker.Unit): TEXT;

PROCEDURE TextHash (t: TEXT): INTEGER;

PROCEDURE WriteStamp (wr: Wr.T;  READONLY x: M3Linker.StampData);

END M3LinkerRep.

