(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: Null.m3                                               *)
(* Last Modified On Mon Mar  2 10:34:32 PST 1992 By kalsow     *)
(*      Modified On Fri Feb  9 06:18:44 1990 By muller         *)

MODULE Null;

IMPORT RefType, Constant, Tipe, AddressExpr, TextExpr, String;

PROCEDURE Initialize () =
  BEGIN
    T := RefType.New (NIL, FALSE, TextExpr.New (String.Add ("$null$")));
    Nil := AddressExpr.New (0);
    Tipe.Define ("NULL", T, TRUE);
    Constant.Declare ("NIL", Nil, TRUE);
  END Initialize;

BEGIN
END Null.
