(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: Floor.m3                                              *)
(* Last Modified On Tue Jun 30 08:51:56 PDT 1992 By kalsow     *)
(*      Modified On Tue Mar 20 04:11:50 1990 By muller         *)

MODULE Floor;

IMPORT CallExpr, Expr, Type, Procedure, Ceiling, Int, Emit;
IMPORT ReelExpr, Temp;

VAR Z: CallExpr.MethodList;

PROCEDURE Check (<*UNUSED*> proc: Expr.T; VAR args: Expr.List;  <*UNUSED*> VAR cs: Expr.CheckState): Type.T =
  BEGIN
    Ceiling.DoCheck ("FLOOR", args);
    RETURN Int.T;
  END Check;

PROCEDURE Compile (<*UNUSED*> proc: Expr.T; args: Expr.List): Temp.T =
  VAR t1, t2: Temp.T;
  BEGIN
    t1 := Expr.Compile (args[0]);
    t2 := Temp.AllocEmpty (Int.T);
    Emit.OpTT ("@ = _FLOOR (@);\n", t2, t1);
    Temp.Free (t1);
    RETURN t2;
  END Compile;

PROCEDURE Fold (<*UNUSED*> proc: Expr.T; args: Expr.List): Expr.T =
  VAR e, x: Expr.T;
  BEGIN
    e := Expr.ConstValue (args[0]);
    IF    (e = NIL)              THEN RETURN NIL;
    ELSIF ReelExpr.Floor (e, x)  THEN RETURN x;
    ELSE  (* bogus *)                 RETURN NIL;
    END;
  END Fold;

PROCEDURE Initialize () =
  BEGIN
    Z := CallExpr.NewMethodList (1, 1, TRUE, FALSE, Int.T,
                                 NIL, Check, Compile, Fold,
                                 CallExpr.IsNever, (* writable *)
                                 CallExpr.IsNever, (* designator *)
                                 CallExpr.NotWritable (* noteWriter *));
    Procedure.Define ("FLOOR", Z, TRUE);
  END Initialize;

BEGIN
END Floor.



