(* Copyright (C) 1989, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Thu Nov  2 21:55:28 1989 by muller         *)
(*      modified on Fri Sep 29 15:43:49 1989 by kalsow         *)
(*      modified on Wed May 27 23:11:56 1987 by mbrown         *)

MODULE Char;

IMPORT Word;

PROCEDURE New (value: T): REF T =
  VAR r: REF T;
  BEGIN
    r := NEW (REF T);
    r^ := value;
    RETURN r;
  END New;

PROCEDURE NewArray (size: CARDINAL;  value: T := NUL): REF ARRAY OF T =
  VAR arr: REF ARRAY OF T;
  BEGIN
    arr := NEW (REF ARRAY OF T, size);
    (* Assumes the allocator initializes to NUL automatically: *)
    IF value # NUL THEN
      FOR i := 0 TO size - 1 DO arr[i] := value END
    END;
    RETURN arr
  END NewArray;

PROCEDURE UntracedNew (value: T): UNTRACED REF T =
  VAR r: UNTRACED REF T;
  BEGIN
    r := NEW (UNTRACED REF T);
    r^ := value;
    RETURN r;
  END UntracedNew;

PROCEDURE UntracedNewArray (size: CARDINAL;  value: T := NUL):
                                                      UNTRACED REF ARRAY OF T =
  VAR arr: UNTRACED REF ARRAY OF T;
  BEGIN
    arr := NEW (UNTRACED REF ARRAY OF T, size);
    (* Assumes the allocator initializes to NUL automatically: *)
    IF value # NUL THEN
      FOR i := 0 TO size - 1 DO arr[i] := value END
    END;
    RETURN arr
  END UntracedNewArray;

PROCEDURE Compare (a, b: T): INTEGER =
  BEGIN
    RETURN ORD (a) - ORD (b);
  END Compare;

PROCEDURE Lt (a, b: T): BOOLEAN =
  BEGIN
    RETURN (a < b);
  END Lt;

PROCEDURE Eq (a, b: T): BOOLEAN =
  BEGIN
    RETURN (a = b);
  END Eq;

PROCEDURE Hash (a: T): INTEGER =
  BEGIN
    RETURN ORD (a);
  END Hash;

BEGIN
  FOR c := '\000' TO '\377' DO Upper[c] := c END;
  FOR c := 'a' TO 'z' DO
    Upper[c] := VAL (ORD (c) - ORD ('a') + ORD ('A'), CHAR);
  END;

  FOR c := '\000' TO '\377' DO Lower[c] := c;  END;
  FOR c := 'A' TO 'Z' DO
    Lower[c] := VAL (ORD (c) - ORD ('A') + ORD ('a'), CHAR);
  END;

  FOR c := '\000' TO '\377' DO
    IF (c IN Graphics)
      THEN Control[c] := VAL (Word.And (ORD (c), 31), CHAR);
      ELSE Control[c] := c;
    END;
  END;
END Char.
