(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)

(* Last modified on Tue Feb 11 16:20:19 PST 1992 by muller                   *)

UNSAFE MODULE CopyBytes;

TYPE T = UNTRACED REF TA; TA = ARRAY [0..1023] OF CHAR;

PROCEDURE P(src, dst: ADDRESS; n: INTEGER) =
  BEGIN
    IF src > dst THEN
      WHILE n # 0 DO
        WITH i = MIN(n, NUMBER(TA)) DO
          WITH srcP = LOOPHOLE(src, T), dstP = LOOPHOLE(dst, T) DO
            SUBARRAY(dstP^, 0, i) := SUBARRAY(srcP^, 0, i)
          END;
          DEC(n, i);
          INC(src, i);
          INC(dst, i)
        END
      END
    ELSE
      INC(src, n);
      INC(dst, n);
      WHILE n # 0 DO
        WITH i = MIN(n, NUMBER(TA)) DO
          DEC(src, i);
          DEC(dst, i);
          WITH srcP = LOOPHOLE(src, T), dstP = LOOPHOLE(dst, T) DO
            SUBARRAY(dstP^, 0, i) := SUBARRAY(srcP^, 0, i)
          END;
          DEC(n, i)
        END
      END
    END  
  END P;

VAR junk := ARRAY [0..3] OF CHAR {'a', ..};

BEGIN
  <* ASSERT ADRSIZE(CHAR) = 1 *>
  FOR i := FIRST(junk) TO LAST(junk) DO
    WITH a = ADR(junk[i]), t = LOOPHOLE(a, T) DO
      <* ASSERT a = ADR(t[0]) *>
    END
  END
END CopyBytes.
