(* Copyright (C) 1992, Digital Equipment Corporation              *)
(* All rights reserved.                                           *)
(* See the file COPYRIGHT for a full description.                 *)
(* Created by stolfi on Wed Apr 19 01:33:17 1989                  *)
(* Last modified on Sun Aug 16 16:05:19 PDT 1992 by meehan    *)
(*      modified on Mon Jun 15 05:45:56 1992 by mhb           *)
(*      modified on Wed Jun  3 18:06:16 PDT 1992 by stolfi        *)
(*      modified on Tue Feb 11 21:39:49 PST 1992 by muller        *)

(* The "ColorName" interface provides a standard mapping between color
   names and linear RGB triples.

   The current implementation recognizes a set of 94 colors
   \footnote{These are drawn from "/usr/lib/X11/rgb.txt".}:

%  There are 94 names.
    \begin{tt}
    \begin{tabular}{llll}
    AliceBlue & ForestGreen & MintCream & SandyBrown \\
    AntiqueWhite \dag & Gainsboro & MistyRose \dag & SeaGreen \dag \\
    Aquamarine \dag & GhostWhite & Moccasin & Seashell \dag \\
    Azure \dag & Gold \dag & NavajoWhite \dag & Sienna \dag \\
    Beige & Goldenrod \dag & Navy & SkyBlue \dag \\
    Bisque & GoldenrodYellow & NavyBlue & SlateBlue \dag \\
    Black & Gray & OldLace & SlateGray \dag \\
    BlanchedAlmond & Green \dag & OliveDrab \dag & SlateGrey \\
    Blue \dag & GreenYellow & OliveGreen \dag & Snow \dag \\
    BlueViolet & Grey & Orange \dag & SpringGreen \dag \\
    Brown \dag & Honeydew \dag & OrangeRed \dag & SteelBlue \dag \\
    Burlywood \dag & HotPink \dag & Orchid \dag & Tan \dag \\
    CadetBlue \dag & IndianRed \dag & PapayaWhip & Thistle \dag \\
    Chartreuse \dag & Ivory \dag & PeachPuff \dag & Tomato \dag \\
    Chocolate \dag & Khaki \dag & Peru & Turquoise \dag \\
    Coral \dag & Lavender & Pink \dag & Violet \\
    CornflowerBlue & LavenderBlush \dag & Plum \dag & VioletRed \dag \\
    Cornsilk \dag & LawnGreen & Powderblue & Wheat \dag \\
    Cyan \dag & LemonChiffon \dag & Purple \dag & White \\
    DeepPink \dag & LimeGreen & Red \dag & WhiteSmoke \\
    DeepSkyBlue \dag & Linen & RosyBrown \dag & Yellow \dag \\
    DodgerBlue \dag & Magenta \dag & Royalblue \dag & YellowGreen \\
    Firebrick \dag & Maroon \dag & SaddleBrown \\
    FloralWhite & MidnightBlue & Salmon \dag \\
    \end{tabular}
    \end{tt}

    The dagger (\dag) indicates that the implementation recognizes
    a name along with the suffixes "1"--"4"; e.g., "Red", "Red1", "Red2",
    "Red3", and "Red4".
    
   The implementation also recognizes the names "Gray0", "Gray1", \dots,
   "Gray100", as well as "Grey0", "Grey1", \dots, "Grey100".
   
   In addition, the name of a color $C$ from this list
   can be prefixed by one or more of the following modifiers:


\begin{center}
\begin{tabular}{l|l}
%
  \begin{tabular}[c]{l} "Light" \\ "Pale" \end{tabular} 
    & means 1/3 of the way from $C$ to white \\ \hline
  \begin{tabular}[c]{l} "Dark" \\ "Dim" \end{tabular} 
    & means 1/3 of the way from $C$ to black \\ \hline
  \begin{tabular}[c]{l} "Drab" \\ "Weak" \\ "Dull" \end{tabular} 
    & $\vcenter{\hbox{means 1/3 of the way from $C$ to the gray}
               \hbox{with the same brightness as $C$}}$ \\ \hline
  \begin{tabular}[c]{l} "Vivid" \\ "Strong" \\ "Bright" \end{tabular} 
    & $\vcenter{\hbox{means 1/3 of the way from $C$ to the purest color}
               \hbox{with the same hue as $C$}}$ \\ \hline
  \begin{tabular}[c]{l} "Reddish" \end{tabular}  
     & means 1/3 of the way from $C$ to red \\ \hline
  \begin{tabular}[c]{l} "Greenish" \end{tabular}  
    & means 1/3 of the way from $C$ to green \\ \hline
  \begin{tabular}[c]{l} "Bluish" \end{tabular}  
    & means 1/3 of the way from $C$ to blue \\ \hline
  \begin{tabular}[c]{l} "Yellowish" \end{tabular}  
    & means 1/3 of the way from $C$ to yellow \\
\end{tabular}
\end{center}

   Each of these modifiers can be modified in turn by the following
   prefixes, which replace ``1/3 of the way'' by the indicated fraction:

   \begin{center}
   \begin{tabular}{lll}
      Term                 & Degree & \% (approx.) \\ \hline   
      "VeryVerySlightly"   & 1/16 of the way   &  6\% \\
      "VerySlightly"       & 1/8 of the way    & 13\% \\
      "Slightly"           & 1/4 of the way    & 25\% \\
      "Somewhat"           & 3/8 of the way    & 38\% \\ 
      "Rather"             & 1/2 of the way    & 50\% \\ 
      "Quite"              & 5/8 of the way    & 63\% \\
      "Very"               & 3/4 of the way    & 75\% \\
      "VeryVery"           & 7/8 of the way    & 88\% \\
      "VeryVeryVery"       & 15/16 of the way  & 94\% \\
   \end{tabular}
   \end{center}

   \noindent The modifier "Medium" is also recognized as a
   shorthand for "SlightlyDark". (But you cannot use "VeryMedium".)

   The names "Undefined" and "NIL" are also recognized, and both
   are mapped to "RGB.Undefined".  These names accept no modifiers.

   So, for example,

| Turquoise 
|  (0.100, 0.814, 1.000)
|
| QuiteStrongTurquoise
|  Mix (FromHue (Hue (Turquoise)),
|       0.625, Turquoise, 0.375)
|
| BluishQuiteStrongTurquoise
|  Mix (Blue, 0.333, QuiteStrongTurquoise, 0.667)
|
| SlightlyDrabBluishQuiteStrongTurquoise
|  Mix (Grey (Brightness (BluishQuiteStrongTurquoise)),
|       0.250, BluishQuiteStrongTurquoise, 0.750)
|
| VeryVeryDarkSlightlyDrabBluishQuiteStrongTurquoise
|  Mix (Black, 0.875, 
|       SlightlyDrabBluishQuiteStrongTurquoise, 0.125)

*)

INTERFACE ColorName;

IMPORT RGB, List;

EXCEPTION NotFound;

PROCEDURE ToRGB (name: TEXT): RGB.T RAISES {NotFound};
(* Give the "RGB.T" value described by "name", ignoring case and
   whitespace.  A cache of unnormalized names is maintained, so
   this procedure should be pretty fast for repeated lookups of
   the same name. *)

PROCEDURE FromRGB (color: RGB.T): TEXT;
(* Guess a descriptive name for the given color.  {\bf WARNING:} This
   procedure is VeryVeryExpensive! *)

PROCEDURE NameList (): List.T;
(* Return a list of all the ``basic'' (unmodified) color names known
   to this module, as lower-case "TEXT"s, in alphabetical order. *)

END ColorName.

