(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)

(* Created by stolfi on Wed Oct 24  2:21:32 PDT 1990           *)
(* Last modified on Tue Feb 11 21:39:49 PST 1992 by muller     *)
(*      modified on Thu Oct 25  9:31:16 PDT 1990 by stolfi     *)

MODULE ColorMatch;

IMPORT Color;

PROCEDURE Nearest(
    READONLY a: Color.T; 
    READONLY table: Table; 
    dist: Color.DistFn;
    parm: REAL := 1.0;
  ): CARDINAL RAISES {EmptyTable} =
  VAR pBest: CARDINAL; 
      d, dBest: REAL;
  BEGIN
    (* dBest := LAST(REAL); *)
    pBest := LAST (CARDINAL);
    FOR p := 0 TO LAST(table) DO
      IF (table[p] = Color.Undefined) THEN
        (* ignore *)
      ELSE
        d := dist (a, table[p], parm);
        IF (pBest = LAST(CARDINAL)) OR (d < dBest) THEN dBest := d; pBest := p END
      END
    END;
    IF pBest = LAST (CARDINAL) THEN RAISE EmptyTable END;
    RETURN pBest
  END Nearest;

PROCEDURE NearestPair(
    a: Color.T; 
    READONLY table: Table; 
    dist: Color.DistFn;
    parm: REAL := 1.0;
  ): IndexPair RAISES {EmptyTable} =
  VAR c: Color.T; 
      pair: IndexPair; 
  BEGIN
    pair[0] := Nearest (a, table, dist, parm);
    c := table[pair[0]];
    a[0] := 2.0 * a[0] - c[0];
    a[1] := 2.0 * a[1] - c[1];
    a[2] := 2.0 * a[2] - c[2];
    pair[1] := Nearest (a, table, dist, parm);
    RETURN pair;
  END NearestPair;

PROCEDURE NearestQuad(
    a: Color.T; 
    READONLY table: Table; 
    dist: Color.DistFn;
    parm: REAL := 1.0;
  ): IndexQuad RAISES {EmptyTable} =
  VAR c: Color.T; 
      quad: IndexQuad; 
      alpha, beta: REAL;
  BEGIN
    quad[0] := Nearest (a, table, dist, parm);
    FOR i := 1 TO 3 DO
      c := table[quad[i - 1]];
      alpha := FLOAT (5 - i);
      beta := 1.0 / (alpha - 1.0);
      a[0] := (alpha * a[0] - c[0]) * beta;
      a[1] := (alpha * a[1] - c[1]) * beta;
      a[2] := (alpha * a[2] - c[2]) * beta;
      quad[i] := Nearest (a, table, dist, parm);
    END;
    RETURN quad;
  END NearestQuad;

BEGIN
END ColorMatch.
