(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: AssignStmt.i3                                         *)
(* Last Modified On Fri Aug 23 00:04:29 1991 By kalsow         *)
(*      Modified On Tue Mar 20 01:30:09 1990 By muller         *)

INTERFACE AssignStmt;

IMPORT Expr, Token, Stmt, Type;

PROCEDURE Parse (READONLY fail: Token.Set): Stmt.T;

PROCEDURE New (lhs, rhs: Expr.T): Stmt.T;

TYPE Kind = { assign, value, var, readonly };

PROCEDURE CheckRHS (lhs: Type.T;  rhs: Expr.T;
                     VAR cs: Stmt.CheckState;  kind := Kind.assign): Expr.T;
(* caller is responsible for generating open array shape checks *)

PROCEDURE NeedsClosureCheck (e: Expr.T): BOOLEAN;
(* TRUE if e is an procedure expression that needs a runtime check
   for a closure *)

END AssignStmt.
