
Meet3D::usage = "Meet3D[a, b], where a is a line and b is a plane or sphere (or
the other way round), or a and b are planes or spheres, gives the intersection 
of a and b."

( Meet3D[Line @ {p_, q_}, w_Plane] := Block[
	{pp, qq, t},
	pp = Project[p, w];
	qq = Project[q, w];
	If[pp == qq, Return[pp]];
	t = Distance[p, pp] Tan[Angle[pp - p, q - p]];
	pp + t Unit[qq - pp] ] 
	/; 0 != (p - q) . PlaneNormal @ w )

Meet3D[w_Plane, l_Line] := Meet3D[l, w]

( Meet3D[v_Plane, w:Plane @ {p_, q_, r_}] := Block[
	{l = {	Meet3D[v, Line @ {p, q}], 
		Meet3D[v, Line @ {q, r}], 
		Meet3D[v, Line @ {r, p}]}},
	Line @ Take[Complement[l, {Indeterminate}], 2] ]
	/; Cross[PlaneNormal @ v, PlaneNormal @ w] != $o ) 

Meet3D[u_Plane, v_Plane, w_Plane] := Meet3D[u, Meet3D[v, w]]

( Meet3D[l:Line @ {p_, q_}, Sphere[e_, r_]] := Block[
	{a, b, c, d, t1, t2},
	a = (q - p) . (q - p);
	b = (q - p) . (e - p);
	c = (e - p) . (e - p) - r ^ 2;
	(* We solve the quadratic a x ^ 2 - 2 b x + c == 0. *)
	d = N @ Sqrt[b ^ 2 - a c];
	t1 = (b - d) / a;
	t2 = (b + d) / a;
	{p + (q - p) t1, p + (q - p) t2} ]
	/; Distance[e, l] <= r )

Meet3D[s_Sphere, l_Line] := Meet3D[l, s]

( Meet3D[w_Plane, Sphere[c1_, r1_]] := Block[{c, r, n},
	c = (c1 + Reflect[w] @ c1) / 2;
	r = N @ Sqrt[r ^ 2 - (c1 - c) . (c1 - c)];
	n = PlaneNormal @ w;
	Circle3D[c, r, n] ] )

Meet3D[s_Sphere, w_Plane] := Meet3D[w, s]

( Meet3D[Sphere[c1_, r1_], Sphere[c2_, r2_]] := Block[{d, t, c, r, n},
	d = Distance[c1, c2];
	t = d / 2 + (r2 ^ 2 - r1 ^ 2) / (2 d);
	c = c1 + t (c2 - c1);
	r = N @ Sqrt[r1 ^ 2 - d ^ 2];
	n = c2 - c1;
	Circle3D[c, r, n] ] 
	/; Abs[r1 - r2] <= Distance[c1, c2] <= r1 + r2 )

