
Lattice::usage = "Lattice[m, u], where m is an integer and u is a triple or 
complex number, gives the list of m terms a u, where a = 0, 1, 2, ... , m - 1.

Lattice[m, u, n, v], where m and n are integers and u and v are triples or 
complex numbers, gives the list of m n terms a u + b v, where 
a = 0, 1, 2, ... , m - 1 and b = 0, 1, 2, ... , n - 1.

Lattice[m, u, n, v, l, w], where m, n and l are integers and u, v and w are 
triples or complex numbers, gives the list of m n l terms a u + b v + c w, 
where a = 0, 1, 2, ... , m - 1, b = 0, 1, 2, ... , n - 1 and 
c = 0, 1, 2, ... , l.

Lattice[{x0, x1, dx}] gives the list of triples of the form 
{Range[x0, x1, dx], 0, 0}.

Lattice[{x0, x1, dx}, {y0, y1, dy}] gives the doubly nested list of triples of 
the form {Range[x0, x1, dx], Range[y0, y1, dy], 0}.

Lattice[{x0, x1, dx}, {y0, y1, dy}, {z0, z1, dz}] gives the triply nested list 
of triples of the form 
{Range[x0, x1, dx], Range[y0, y1, dy], Range[z0, z1, dz]}."


Lattice[m_, u_] := Block[{x}, Table[x u, {x, 0, m - 1}] ]

( Lattice[m_, u_, n_, v_] := Block[
	{x, y},
	Flatten[Table[x u + y v, {x, 0, m - 1}, {y, 0, n - 1}], 1] ] )

( Lattice[m_, u_, n_, v_, l_, w_] := Block[
	{x, y, z},
	Flatten[Table[x u + y v + z w, 
		{x, 0, m - 1}, {y, 0, n - 1}, {z, 0, l -1}], 2] ] )

