
Dilate::usage = "Dilate[x, c][g] is the magnification of the figure g by 
the factor x with c as centre."

( Dilate[x_?NumberQ, z:{_?NumberQ, _?NumberQ, _?NumberQ}] @ 
	p:{_?NumberQ, _?NumberQ, _?NumberQ} := z + x (p - z) )

( Dilate[x_?NumberQ, z:{_?NumberQ, _?NumberQ, _?NumberQ}] @ 
	Point[p:{_?NumberQ, _?NumberQ, _?NumberQ}] := 
	Point[z + x (p - z)] )

( Dilate[x_?NumberQ, z:{_?NumberQ, _?NumberQ, _?NumberQ}] @ Line @ g_ := 
	Line @ MapAt[z + x (# - z) &, g, 
		Position[g, {_?NumberQ, _?NumberQ, _?NumberQ}]] )

( Dilate[x_?NumberQ, z:{_?NumberQ, _?NumberQ, _?NumberQ}] @ Polygon @ g_ := 
	Polygon @ MapAt[z + x (# - z) &, g, 
		Position[g, {_?NumberQ, _?NumberQ, _?NumberQ}]] )

( Dilate[x_?NumberQ, z:{_?NumberQ, _?NumberQ, _?NumberQ}] @ Circle[c_, r_] := 
	Circumcircle @ Dilate[x, z] @ {c + r $i, c + r $j, c - r $i} )

( Dilate[x_?NumberQ, z:{_?NumberQ, _?NumberQ, _?NumberQ}] @ u_Disk := 
	Disk @@ Dilate[x, z][Circle @@ u] )

( Dilate[x_?NumberQ, z:{_?NumberQ, _?NumberQ, _?NumberQ}] @ 
	Plane @ {p_, q_, r_} := Plane @ Dilate[x, z] @ {p, q, r} )

( Dilate[x_?NumberQ, z:{_?NumberQ, _?NumberQ, _?NumberQ}] @ Sphere[c_, r_] := 
	Circumsphere @ Dilate[x, z] @ 
		{c + r $i, c + r $j, c + r $k, c - r $i} )

( Dilate[x_?NumberQ, z:{_?NumberQ, _?NumberQ, _?NumberQ}] @ 
	Text[t_, p:{_?NumberQ, _?NumberQ, _?NumberQ}, a___] := 
	Text[t, Dilate[x, z] @ p, a] )

( Dilate[_?NumberQ, z:{_?NumberQ, _?NumberQ, _?NumberQ}] @ 
	GrayLevel[i_] := GrayLevel[i] )

( Dilate[_?NumberQ, z:{_?NumberQ, _?NumberQ, _?NumberQ}] @ 
	RGBColor[r_, g_, b_] := RGBColor[r, g, b] )

( Dilate[_?NumberQ, z:{_?NumberQ, _?NumberQ, _?NumberQ}] @ 
	PointSize[s_] := PointSize[s] )

( Dilate[_?NumberQ, z:{_?NumberQ, _?NumberQ, _?NumberQ}] @ 
	Thickness[t_] := Thickness[t] )

( Dilate[_?NumberQ, z:{_?NumberQ, _?NumberQ, _?NumberQ}] @ 
	Dashing[d_] := Dashing[d] )

( Dilate[_?NumberQ, z:{_?NumberQ, _?NumberQ, _?NumberQ}] @ 
	EdgeForm[] := EdgeForm[] )

( Dilate[_?NumberQ, z:{_?NumberQ, _?NumberQ, _?NumberQ}] @ 
	EdgeForm[e_] := EdgeForm[e] )

Dilate[x_?NumberQ, l_] @ g_List := Dilate[x, l] /@ g

Dilate[x_?NumberQ, l_List] @ g_ := Dilate[x, #] @ g & /@ l

Dilate[l_List, z_] @ g_ := Dilate[#, z] @ g & /@ l

