(*^
*)
GastropodShellRotate[genus_, genusaperture_, phases_] := Module[ 
{l, gat, gacg, whorl, gar, i, j}, 
l = ReadGastropodShellParameters @ phases; 
gat = GastropodApertureTrajectoryParameters[genus, phases, l]; 
gacg = GastropodApertureCircularGeometricParameters[genus, phases, l]; 
gae = GastropodApertureExpansionParameters[genusaperture, phases, l]; 
rotationangle = GastropodApertureRotation[genus, phases, l]; 
Flatten[ 
Table[ 
	Rotate[ 
		N[rotationangle[[i]]],  
		(Line /@ Partition[GastropodApertureTrajectory @@ gat[[i]], 
			2, 1])[[j]] 
	][  
		Map[ 
		    PreDraw3D[WheelEllipse @@ #]&,	 
			Thread @  
				{ 
				Line /@ Partition[ 
				       GastropodApertureTrajectory @@ gat[[i]], 
				       2, 1], 
				Drop[GastropodApertureExpansion @@ gae[[i]],-1] 
				} 
		 ][[j]] 
     	 ], 
	{i, 1, phases}, 
	{j, 1, gacg[[i]][[3]]} 
], 
1 
] 
] 
		 


(*


^*)