 /*
  * Khoros: $Id: get_token.c,v 1.2 1991/10/01 23:57:39 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: get_token.c,v 1.2 1991/10/01 23:57:39 khoros Exp $";
#endif

 /*
  * $Log: get_token.c,v $
 * Revision 1.2  1991/10/01  23:57:39  khoros
 * HellPatch2
 *
  */ 


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>     file name: get_token.c                            <<<<
   >>>>                                                       <<<<
   >>>>   description: see below                              <<<<
   >>>>                                                       <<<<
   >>>>      routines: get_1st_token                          <<<<
   >>>>                get_2nd_token                          <<<<
   >>>>                                                       <<<<
   >>>>        author: W. Tait Cyrus -- May 31, 1990          <<<<
   >>>>                                                       <<<<
   >>>> modifications:                                        <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */

#include "imkmf.h"

/*
 * This routine returns the first "token" found in the specified `line'.
 * A token is terminated by one of: white space, an equal, a colon, or
 * a newline.
 */

int
get_1st_token( buffer, token )
   char *buffer;
   char *token;
   {
   char *c;
   int len;

   c = buffer;
   len = 0;
   while( isspace( *c ) ) c++;	/* Skip over any white space */
   while( *c ) {
      if( (*c == ' ') ||
	  (*c == '\t') ||
	  (*c == '=') ||
	  (*c == ':')  ||
	  (*c == '\n') ) {
         token[len] = 0;
         return( 1 );
	 }
      else {
	 token[len++] = *c++;
	 }
      }
   return( 0 );
   }

/*
 * This routine returns the second "token" found in the specified `line'.
 * A token is terminated by one of: white space, an equal, a colon, or
 * a newline.
 */

int
get_2nd_token( buffer, token )
   char *buffer;
   char *token;
   {
   char *c;
   int len;

   c = buffer;
   len = 0;
   while( isspace( *c ) ) c++;	/* Skip over any white space */
   while( *c && !isspace( *c ) ) c++;	/* Skip over first token */
   while( isspace( *c ) ) c++;	/* Skip over any white space */
   while( *c ) {
      if( (*c == ' ') ||
	  (*c == '\t') ||
	  (*c == '=') ||
	  (*c == ':')  ||
	  (*c == '\n') ) {
         token[len] = 0;
         return( 1 );
	 }
      else {
	 token[len++] = *c++;
	 }
      }
   return( 0 );
   }
