 /*
  * Khoros: $Id: vpolyco.c,v 1.1 1991/05/10 15:52:15 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vpolyco.c,v 1.1 1991/05/10 15:52:15 khoros Exp $";
#endif

 /*
  * $Log: vpolyco.c,v $
 * Revision 1.1  1991/05/10  15:52:15  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vpolyco.c
 >>>>
 >>>>      Program Name: vpolyco
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Compute polynomial warp coefficients
 >>>>	
 >>>>	
 >>>>            Author: Scott Wilson
 >>>>
 >>>> Date Last Updated: Thu Mar 28 00:20:47 1991
 >>>>
 >>>>          Routines: main- the main program for vpolyco
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vpolyco.h"


/****************************************************************
 *
 * Routine Name:  main program for vpolyco
 *
 *       Input:  
 *         -i1  Source tie point image 
 *         -i2  Target tie point image 
 *         -o1  X vwarp coefficients image 
 *         -o2  Y vwarp coefficients image 
 *
 *
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
        struct xvimage *source,*target,*readimage();
        float *x,*y,*xp,*yp,*xc,*yc,*f,*g;
        int i,k,sqrtk;

/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        if (check_args()) exit(1);

        /* Read the input images (really the tie point coordinates) */
        source = readimage(vpolyco->i1_file);
        if (source == NULL) exit(1);
        target = readimage(vpolyco->i2_file);
        if (target == NULL) exit(1);

        CHECKINPUT(program,source,target);  /* Verify input images */

        /* Check the type and size of both input images. They should be
        VFF_TYP_FLOAT and N rows by 2 columns. */
        if (source->data_storage_type != VFF_TYP_FLOAT )
          {
            fprintf(stderr,"vpolyco: source tiepoint image should be FLOAT\n");
            exit(1);
          }
        if (source->row_size != 2 )
          {
            fprintf(stderr,"vpolyco: source tiepoint image should be 2 columns wide\n");
            exit(1);
          }
        if (target->data_storage_type != VFF_TYP_FLOAT )
          {
            fprintf(stderr,"vpolyco: target tiepoint image should be FLOAT\n");
            exit(1);
          }
        if (target->row_size != 2 )
          {
            fprintf(stderr,"vpolyco: target tiepoint image should be 2 columns widec olumns\n");
            exit(1);
          }
        if (source->col_size != target->col_size)
          {
            fprintf(stderr,"vpolyco: source and target tiepiont count differs\n");
            exit(1);
          }

        /* Check for a legal number of tiepoints */
        k = source->col_size;
        for (sqrtk=0; sqrtk<1000; sqrtk++) if (k == sqrtk*sqrtk) break;
        if (sqrtk == 1000)
          {
            fprintf(stderr,"vpolyco: number of tiepoints must be a squared integer!\n");
            exit(1);
          }
        /* Allocate space for the tiepoint and coefficient arrays */
        x = (float *)malloc(k*sizeof(float));
        y = (float *)malloc(k*sizeof(float));
        xp = (float *)malloc(k*sizeof(float));
        yp = (float *)malloc(k*sizeof(float));
        xc = (float *)malloc(k*k*sizeof(float));
        yc = (float *)malloc(k*k*sizeof(float));

        /* Read the tiepoint coordinates into thier respective arrays */
        g = (float *)(source->imagedata);
        f = (float *)(target->imagedata);
        for (i=0; i<k; i++)
          {
            x[i]  = *f++; y[i]  = *f++;
            xp[i] = *g++; yp[i] = *g++;
          }
/* -main_before_lib_call_end */

/* -main_library_call */
        if (!lvpolyco(x,y,xp,yp,xc,yc,k))
          {
            (void)fprintf(stderr,"lvpolyco failed\n");
            exit(1);
          }
/* -main_library_call_end */

/* -main_after_lib_call */
    /* Now build an image for the X and Y coefficients */
    /* Assume the colormap stuff is OK */
    source->col_size      = sqrtk;
    source->row_size      = sqrtk;
    source->data_storage_type    = VFF_TYP_FLOAT;
    source->num_of_images    = 1;
    source->num_data_bands    = 1;
    source->map_scheme    = VFF_MS_NONE;
    source->location_type    = VFF_LOC_IMPLICIT;
    source->startx        = VFF_NOTSUB;
    source->starty        = VFF_NOTSUB;

    /* Now write out the coefficient images */
    source->imagedata = (char *)xc;
    writeimage(vpolyco->o1_file,source);

    source->imagedata = (char *)yc;
    writeimage(vpolyco->o2_file,source);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vpolyco 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vpolyco :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tCompute polynomial warp coefficients\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i1  Source tie point image  (infile)\n");
	fprintf(stderr,"\t-i2  Target tie point image  (infile)\n");
	fprintf(stderr,"\t-o1  X vwarp coefficients image  (outfile)\n");
	fprintf(stderr,"\t-o2  Y vwarp coefficients image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vpolyco\n");
	fprintf(stderr, "\t[-U] Gives the usage for vpolyco\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vpolyco.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vpolyco.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vpolyco
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i1_pstr = 
	"\nEnter: (i1) Source tie point image \n        {infile}: "; 
char	*i2_pstr = 
	"\nEnter: (i2) Target tie point image \n        {infile}: "; 
char	*o1_pstr = 
	"\nEnter: (o1) X vwarp coefficients image \n        {outfile}: "; 
char	*o2_pstr = 
	"\nEnter: (o2) Y vwarp coefficients image \n        {outfile}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vpolyco", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vpolyco.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vpolyco: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vpolyco.ans");
		}

	     }

	}

	/*
	 * allocate the vpolyco structure
	 */
	vpolyco = (vpolyco_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vpolyco_struct));

	/*
	 * get required arguments for vpolyco
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vpolyco->i1_flag = vget_infile(fid, prompt_flag,
			"-i1", i1_pstr, &(vpolyco->i1_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vpolyco->i1_flag))
		{
		    fprintf(stderr, "\t\ti1 is required, please re-enter: \n");
		    vpolyco->i1_flag = vget_infile(fid, prompt_flag,
		    "-i1", i1_pstr, &(vpolyco->i1_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i1' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vpolyco->i2_flag = vget_infile(fid, prompt_flag,
			"-i2", i2_pstr, &(vpolyco->i2_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vpolyco->i2_flag))
		{
		    fprintf(stderr, "\t\ti2 is required, please re-enter: \n");
		    vpolyco->i2_flag = vget_infile(fid, prompt_flag,
		    "-i2", i2_pstr, &(vpolyco->i2_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i2' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vpolyco->o1_flag = vget_outfile(fid, prompt_flag,
			"-o1", o1_pstr, &(vpolyco->o1_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vpolyco->o1_flag))
		{
		    fprintf(stderr, "\t\to1 is required, please re-enter: \n");
		    vpolyco->o1_flag = vget_outfile(fid, prompt_flag,
		    "-o1", o1_pstr, &(vpolyco->o1_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o1' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vpolyco->o2_flag = vget_outfile(fid, prompt_flag,
			"-o2", o2_pstr, &(vpolyco->o2_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vpolyco->o2_flag))
		{
		    fprintf(stderr, "\t\to2 is required, please re-enter: \n");
		    vpolyco->o2_flag = vget_outfile(fid, prompt_flag,
		    "-o2", o2_pstr, &(vpolyco->o2_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o2' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}


}



