 /*
  * Khoros: $Id: lasc2viff.c,v 1.1 1991/05/10 15:43:29 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lasc2viff.c,v 1.1 1991/05/10 15:43:29 khoros Exp $";
#endif

 /*
  * $Log: lasc2viff.c,v $
 * Revision 1.1  1991/05/10  15:43:29  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lasc2viff.c
 >>>>
 >>>>      Program Name: asc2viff
 >>>>
 >>>> Date Last Updated: Wed Mar 27 18:34:12 1991 
 >>>>
 >>>>          Routines: lasc2viff - the library call for asc2viff
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lasc2viff - library call for asc2viff
*
* Purpose:
*    
*    Transforms ASCII data into a VIFF file format.
*    
*    
* Input:
*    
*         filename: file name of the INPUT ASCII file
*         image: the resulting viff image
*         nrows: number of rows
*         ncols: number of colsumns
*         offset: header offset to skip for the given file
*         start: start offset for each band
*         row_skip, col_skip: number of points to be skipped along the
*         column and rows.
*         numbands: number of bands in the file
*         dimension: number of locations  bands  default  is  0  which
*         implies an implicit image
*         interleave: whether data is interleaved or not
*         complex: data can be either real or complex
*    
*    
* Output:
*    
*         image: hold the result.
*    
*    
*
* Written By: Ramiro Jordan, Mike Lang, Mark Young
*    
*    Ghosted by Pascal ADAM Wed Jun 13 15:08:22 MDT 1990
*    
*    
****************************************************************/


/* -library_def */
int
lasc2viff(filename, 
            image, 
            nrows, 
            ncols, 
            offset, 
            start, 
            row_skip, 
            col_skip,
            numbands, 
            dimension, 
            interleave,
            complex)

int     nrows, 
        ncols, 
        offset, 
        start, 
        row_skip, 
        col_skip, 
        numbands,
        dimension, 
        interleave, 
        complex;
char    *filename;
struct  xvimage **image;

/* -library_def_end */

/* -library_code */
{
  FILE   *file;
  float  *data, *newdata, *read_ascii();
  int    size, nr, nc, length, numsets;
  struct xvimage *img, *createimage();
  unsigned long data_storage_type, location_type;


   /* convert file descriptor to stream pointer */
   if ((file = fopen (filename, "r")) == NULL)
   {
      (void) fprintf(stderr, "Not a valid file descriptor.");
      return(0);
   }

   if ( numbands < 1 )
   {
         (void) fprintf(stderr, "Number of bands must be >= than 1" );
         return(0);
   }
   if (offset < 0)
   {
         (void)fprintf (stderr, "Header offset must be >= than 0" );
         return(0);
   }
   if (start < 0)
   {
         (void)fprintf (stderr, "Start offset must be >= than 0" );
         return(0);
   }
   if (row_skip < 1 || col_skip < 1)
   {
         (void) fprintf(stderr, "Row and column increment factors must be >= \
than 1" );
         return(0);
   }

   if (!(data = read_ascii(file, &length)))
   {
      return(0);
   }
   else if (offset > 0)
   {
      newdata = &data[offset];
      length -= offset;
   }
   else
      newdata = data;

   size = length;
   if (complex == 1)            /* complex image data */
      numsets = (dimension + numbands * 2);
   else
      numsets = (dimension + numbands);

   length /= numsets;
   if (length < 1)
   {
      (void) fprintf(stderr, "Not enough data found in ascii file!\n Need at \
least %d data point, but found only %d data points\n", numsets, size);
      return(0);
   }

   if (nrows == 0)
   {
      nrows = 1;
   }
   if (ncols == 0)
   {
      ncols = length;
   }

   /*
    *  Make sure that there is enough ascii data in order to get the number
    *  of desired points (nrows*ncols).
    */
   size = nrows*ncols;

   
   if ((length - start) < size)
   {
         (void) fprintf(stderr, "\nOut of bounds! Number of requested rows and \
columns is greater than \nthe number of points per band found in the data file.\
\nNumber of points in the file per band is %d,\nnumber of expected points per \
band is %d.  (Num of rows = %d Num of cols = %d)\n\n", (length - start), size,
nrows, ncols);
         return(0);
   }

   if(dimension == 0)
   {
        location_type = VFF_LOC_IMPLICIT;
   }
   else
   {
        location_type = VFF_LOC_EXPLICIT;
   }

   if (complex == 1)
        data_storage_type = VFF_TYP_COMPLEX;
   else
        data_storage_type = VFF_TYP_FLOAT;

   nr = (1 + (nrows -1)/row_skip);
   nc = (1 + (ncols -1)/col_skip);
   img = createimage(   (unsigned long) nr,    /* number of rows */
                        (unsigned long) nc,    /* number of columns */
                        (unsigned long)
                        data_storage_type,             /* data_storage_type */
                        (unsigned long) 1,             /* num_of_images */
                        (unsigned long) numbands,      /* num_data_bands */
                        "created by lasc2viff",        /* comment */
                        (unsigned long) 0,              /* map_row_size */
                        (unsigned long) 0,              /* map_col_size */
                        (unsigned long)
                        VFF_MS_NONE,                    /* map_scheme */
                        (unsigned long)
                        VFF_MAPTYP_NONE,                /* map_storage_type */
                        (unsigned long)
                        location_type,                     /* location_type */
                        (unsigned long) dimension);     /* dimension */

   *image = img;
   if ( img == NULL )
   {
       (void)fprintf(stderr,"lasc2viff: Unable to allocate new image!\n");
       return(0);
   }

   /*  massage data points into specified form */
   load_viff_data(newdata, (float *)img->imagedata, img->location, nrows, ncols,
                  numbands, dimension, interleave, start, row_skip, col_skip,
                  complex);

   free((char *) data);
   return (1);

} /* end of lasc2viff */
/* -library_code_end */
