################################################################################
##
##	.cshrc file
##
##	The .cshrc file contains which affect the user environment.  This
##	file is sourced when you log in and once for every window you
##	start.  This is the place where the majority of the customizations
##	for your Sun workstation environment are made.
##
##	This file is generated automatically for new users the first time
## 	they log in.  You should be able to run the program "user-setup"
##	at any time to reconfigure this file.  The user-setup program
##	is interactive and will ask you questions about what software
##	you intend to run.  The user-setup program will be aware of all
##	currently installed major software packages available on the
##	College of Engineering network.
##
##	This file can be edited by hand to suit your tastes.  There is a
##	section called "personal customization area" which should contain
##	your personal additions.  Any commands placed in the "personal 
##	customization area" will be automatically included in any new
##	.cshrc file created by "user-setup".  This area is near the bottom
##	of this file so that you could override any setup done by 
##	user-setup.
##
##	More information on C-shells and .cshrc files can be found in the
##	man pages for csh.  Type "man csh".
##
##
## @(#)prologue.cshrc	2.2	1/20/93	Auburn University Engineering

######  switches to be set

## If set, noclobber will help prevent you from accidently clobbering a
## file by using I/O redirection.  The disadvantage of this is that some
## shell scripts expect to be allowed to write over files.  You can
## override this by using >! or >>!.
set noclobber  # For now, better safe than sorry...

## If set, ignoreeof will not allow you to exit the shell by typing
## [CTRL-D].  This is especially useful if you also set filec.
set ignoreeof

## If set, notify will display job control status messages immediately.
## Otherwise, job control status messages will be displayed after you
## type a carriage return.
set notify

######  history related variables

## The history variable indicates the number of commands to be kept
## in the shell`s memory.  set history=40
set history=40

######  C-shell limits to be set

##  The limits set here are intended to cut down on users accidently
##  tying up system resources.  See the man page on csh for more info.
limit cputime 1h      ## cputime limit 1 hour
limit filesize 4m     ## filesize limit to 4 megabytes
limit coredumpsize 0  ## don't make core files

######  user security

## The umask is applied to the file permissions for every file created
## by the user.  Typically we do not want everyone to be able to write
## to files we create so we disable write permission for others.
## Common values are:
##
## +-------+--------------------+--------------------+--------------------+
## | umask |      Myself        |     My Group       |     All Others     |
## | value | read write execute | read write execute | read write execute |
## +-------+--------------------+--------------------+--------------------+
## |  000  |  yes   yes   yes   |  yes   yes   yes   |  yes   yes   yes   |
## |  002  |  yes   yes   yes   |  yes   yes   yes   |  yes   ---   yes   |
## |  006  |  yes   yes   yes   |  yes   yes   yes   |  ---   ---   yes   |
## |  007  |  yes   yes   yes   |  yes   yes   yes   |  ---   ---   ---   |
## |  022  |  yes   yes   yes   |  yes   ---   yes   |  yes   ---   yes   |
## |  066  |  yes   yes   yes   |  ---   ---   yes   |  ---   ---   yes   |
## |  067  |  yes   yes   yes   |  ---   ---   yes   |  ---   ---   ---   |
## |  077  |  yes   yes   yes   |  ---   ---   ---   |  ---   ---   ---   |
## +-------+--------------------+--------------------+--------------------+
##
## Note that files are only created with execute permission when:
##   1. they have been generated by a compiler
##   2. a new directory is created
##
umask 077    #  prevent browsing of your directory.

##
## Now we are ready to look for modules.  Each module adds an application
## to the environment.  You can add or remove modules on the fly.  See
## the man page on modules for more information.
##
if ( -d /usr/modules) then
	source /usr/modules/init/csh
	set path = ""
	## the following line is crucial... this is where all initial
	## modules are loaded.
	module load unix/bsd
	if ( $status != 0 ) then
		echo "WARNING: couldn't load modules.  Entering generic environment."
		set path = (/usr/ucb /usr/bin /usr/local/bin .)
	endif
else
	## couldn't find the modules package so
	set path = (/usr/ucb /usr/bin /usr/local/bin .)
	echo "WARNING: couldn't load modules.  Entering generic environment."
endif

## DO NOT CHANGE THE NEXT LINE!!!!
##  ----start-personal-customization-area----
