/*This line lets emacs recognize this as -*- C -*- Code
 *-----------------------------------------------------------------------------
 *
 * Project:	Tcl Modules
 * Created:	92/10/28
 * Author:	John L. Furlani<john.furlani@East.Sun.COM>
 *
 * Description:
 *      Uses the beginning environment stored the first time each login
 *  session to reload all of the currently loaded modulefiles.  This is here
 *  for the cases when the user has accidentally modified the environment or
 *  unset certain variables.
 *	
 * $Log: ModuleCmd_Update.c,v $
 *
 *
 * Revision 1.3  1993/01/23  01:01:23  jlf
 * Fixed a number of memory leaks and large static arrays.
 *
 * Revision 1.2  1993/01/20  03:34:07  jlf
 * Updated to use new version of ModuleCmd_Load()
 *
 * Revision 1.1  1992/11/05  23:54:31  jlf
 * Initial revision
 *
 *---------------------------------------------------------------------------*/
static char Id[] =
    "$Id: ModuleCmd_Update.c,v 2.0 1993/02/21 00:00:21 jlf Exp jlf $";

#include "global.h"

int
ModuleCmd_Update(Tcl_Interp* interp,
                 int         count,
                 char*       module_list[])
{
    char*  buf;
    char*  varbuf;
    char*  valbuf;
    int    list_count = 0, maxlist = 16;
    char** load_list;
    char*  tmpload = getenv("LOADEDMODULES");
    char*  loaded;

    if(! tmpload) { return TCL_OK; }

    if((buf = (char*)malloc(524288*sizeof(char))) == NULL) {
        fprintf(stderr, "Couldn't malloc 524288 bytes for update\n");
        return TCL_ERROR;
    }

    /*
     *  First I'll update the environment with what's in _MODULESBEGINENV_
     */
    {
        char* filename;
        FILE* file;

        filename = Tcl_GetVar2(interp, "env", "_MODULESBEGINENV_", TCL_GLOBAL_ONLY);
        if(filename) {
            if((file=fopen(filename, "r")) != NULL) {
                while(!feof(file)) {
                    fscanf(file, "%s", buf);
                    varbuf = strchr(buf, '=');
                    if(varbuf) {
                        *varbuf = '\0';
                        valbuf = varbuf+1;
                        varbuf = buf;

                        if(strncmp(varbuf, "LOADEDMODULES", 12))
                            if(!strncmp(varbuf, "MODULEPATH", 10))
                                moduleSetenv(interp, varbuf, valbuf, 1);
                            else
                                Tcl_SetVar2(interp, "env", varbuf, valbuf,
                                            TCL_GLOBAL_ONLY);
                    }
                }
                fclose(file);
            }
        }
    }

    free(buf);

    if((load_list = (char**) malloc(maxlist*sizeof(char**))) == NULL) {
	fprintf(stderr, "ERROR:  malloc() failed.\n");
	return TCL_ERROR;
    }
    
    if((loaded = (char*) malloc(strlen(tmpload) + 1)) == NULL) {
	fprintf(stderr, "ERROR:  malloc() failed.\n");
	return TCL_ERROR;
    }
    
    strcpy(loaded, tmpload);
    
    if(*loaded) {
	load_list[list_count++] = strtok(loaded, ":");
	
	while(load_list[list_count-1]) {
            if(list_count >= maxlist) {
                maxlist = maxlist<<1;
            
                if((load_list = (char**) realloc(load_list, maxlist*sizeof(char**)))
                    == NULL) {
                    fprintf(stderr, "ERROR:  realloc() failed.\n");
                    return TCL_ERROR;
                }
            }
                
            load_list[list_count++] = strtok(NULL, ":");
	}
        ModuleCmd_Load(interp, 1, list_count, load_list);
    }
    free(loaded);
    free(load_list);

    return TCL_OK;
}
