/*
 *  securelib:  a package to enhance network security.
 *
 *  Written by William LeFebvre, EECS Department, Northwestern University
 *  Internet address:  phil@eecs.nwu.edu
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/syscall.h>
#include <errno.h>

recvfrom(s, buf, len, flags, from, fromlen)

int s;
char *buf;
int len, flags;
struct sockaddr *from;
int *fromlen;

{
    register int retval;

    if ((retval = syscall(SYS_recvfrom, s, buf, len, flags, from, fromlen)) >= 0)
    {
	if (_ok_address(s, from, *fromlen))
	{
	    return (retval);
	}
	errno = ECONNREFUSED;
	return (-1);
    }
    return (retval);
}
