/*
 * port_mgr.h
 *
 * x-kernel v3.2
 *
 * Copyright (c) 1991  Arizona Board of Regents
 *
 *
 * $Revision: 1.7 $
 * $Date: 1992/01/29 09:01:02 $
 */

/* 
 * This file defines the prototypes for the port management functions.
 * A header file with these prototypes can be formed by defining the macro
 *	NAME -- token to prepend to routine names
 * and then including this file.
 */


typedef enum {
    HONOR_PORT_LOCK,
    OVERRIDE_PORT_LOCK
} LockCmd;


#ifdef __STDC__
#define XPASTE(X,Y) X##Y
#define PASTE(X,Y) XPASTE(X,Y)

/* 
 * Initializes the UDP port map.  Must be called before any other routines. 
 */
void	PASTE(NAME, PortMapInit) ( void );

/* 
 * Attempts to lock the specified port.  If a port is locked, it will
 * not be returned from GetFreePort() and calls to DuplicatePort() to it
 * will require an OVERRIDE_PORT_LOCK directive to succeed.
 *
 * LockPort will succeed (and return 0) only if the port is being used
 * for nothing else.  If the port is being used or the specified port
 * is out of range, LockPort will fail and return non-zero.
 */
int	PASTE(NAME, LockPort) ( long );

/* 
 * Attempts to get a free port > FIRST_USER_PORT, placing the
 * new port in *port.  Returns 0 if successful, non-zero if not.
 * The new port is not locked.
 */
int	PASTE(NAME, GetFreePort) ( long * );

/* 
 * Increases the reference count of the port.  The port does not have
 * to have been previously acquired.  If the port is locked, this
 * operation will fail unless the LockCmd == OVERRIDE_PORT_LOCK.
 */
int	PASTE(NAME, DuplicatePort) ( long, LockCmd );

/* 
 * Decreases the reference count on a port previously acquired through
 * udpDuplicatePort() or udpGetFreePort().
 */
void	PASTE(NAME, ReleasePort) ( long );

/* 
 * Undoes a LockPort().
 */
void	PASTE(NAME, UnlockPort) ( long );


#endif
