/*
 * timeudp.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright 1990  Larry L. Peterson and Norman C. Hutchinson
 */

/********************************************************************
 *
 * Test UDP
 *	TRIPS: number of round trips per test
 *	TIMES: number of tests run
 *	Set message size by defining one of the following:
 *		ONESHOT = 1 byte
 *		LITTLE = 1, 200, 400, ... 1400 bytes
 *
 ********************************************************************/

#define LITTLE

#include "xkernel.h"
#include "ip.h"
#include "udp.h"
#undef assert
#define assert(x) 

#define IP_NULL { 0, 0, 0, 0 };


static Protl IP, UDP;
static unsigned short clientport = 2001;
static unsigned short serverport = 2002;

IPhost client_host = SITE_CLIENT_IP;
IPhost server_host = SITE_SERVER_IP;
IPhost ip_null = IP_NULL;

UDPaddr CLIENT, SERVER;
char *SERVERNAME;

typedef struct {
  int sec, usec;
} time;

static time starttime;
static int gotone;
static int count;
#define TRIPS 1000
#define TIMES 5
#define DELAY 2000

client()
{
  int p, s;
  int clientdemux(), null();
  Part whom[3];
  static char message[8 * 1024];
  int test = 0;
  int lenindex, len;
  static int lens[] = { 
#ifdef ONESHOT
    1,
#endif
#ifdef LITTLE
    1, 200, 400, 600, 800, 1000, 1200, 1400, 1024,
#endif  
  };

  s = NULL;
  p = xcreateprotl(clientdemux, null, null);
  printf("I am the client, talking to %s <%d.%d.%d.%d>\n", SERVERNAME,
	 SERVER.host.a, SERVER.host.b, SERVER.host.c, SERVER.host.d);
  init_partlist(whom, 2, UDPaddr);
  set_part(whom, 0, CLIENT);
  set_part(whom, 1, SERVER);
  for (lenindex = 0; ; lenindex++) {
    if (lenindex >= sizeof(lens)/sizeof(long)) lenindex = 0;
    len = lens[lenindex];
    for (test = 0; test < TIMES; test++) {
      if (s <= 0) s = xopen(p, UDP, whom);
      if (s > 0) {
	printf("Sending (%d) ...\n", test);
	count = 0;
#ifdef PROFILE
	startProfile();
#endif
	xgettime(&starttime);
	xpush(s, message, len, 0, 0);
      } else {
	printf("Not sending, other host not up\n");
      }
      do {
	gotone = 0;
	xpause(DELAY);
      } while (gotone);
      if (count < TRIPS) {
	printf("Test failed after receiving %d packets\n", count);
      }
    }
  }
}
  
server()
{
  int serverdemux(), null(), p;
  Part whom[2];
  printf("I am the  server (%s)\n", SERVERNAME);
  init_partlist(whom, 1, UDPaddr);
  set_part(whom, 0, SERVER);
  p = xcreateprotl(serverdemux, null, null);
  (void) xopenenable(p, UDP, whom);
}


int strtoi(s)
    char *s;
{
    int i = 0;

    while(1) {
	if (*s < '0' || *s > '9') return i;
	i *= 10;
	i += (*s - '0');
	s++;
    }
}


IPhost stringtoip(s)
  char *s;
{
  IPhost h;
  char *t;
  int i;

  t = s;
  for (i=0; i<3; i++) {
      if (t = index(s, '.')) {
	  *((char *)&h + i) = strtoi(s);
	  s = t+1;
      } else {
	  return ip_null;
      }
  }
  h.d = strtoi(s);
  return h;
}    



user(argc, argv)
int argc;
char **argv;
{
  char arr[24];
  IPhost ipaddr, nametoip();
  printf("UDP timing test\n");
  IP = xgetprotlbyname("ip");
  UDP = xgetprotlbyname("udp");
  CLIENT.host = client_host;
  SERVER.host = server_host;
  SERVERNAME = SITE_SERVER_NAME;
  if (xcontrolprotl(IP, GETMYADDR, &ipaddr, sizeof(IPhost)) != 
      sizeof(IPhost)) {
    printf("Cannot get my own IP addr\n");
    return;
  } else {
    printf("My IP addr = %d.%d.%d.%d\n", ipaddr.a, ipaddr.b, ipaddr.c, ipaddr.d);
  }

  while (argc > 1) {
    if (!strncmp(argv[1], "-s", 2)) {
      SERVER.host = ipaddr;
      SERVERNAME = malloc(24);
      iptoname(SERVER.host, SERVERNAME);
      CLIENT.host.a = CLIENT.host.b = CLIENT.host.c = CLIENT.host.d = 0;
    } else if (!strncmp(argv[1], "-c", 2)) {
      CLIENT.host = ipaddr;
      SERVERNAME = malloc(24);
      strcpy(SERVERNAME, &argv[1][2]);
      if (*SERVERNAME >= '0' && *SERVERNAME <= '9') {
	SERVER.host = stringtoip(SERVERNAME);
      } else {
	SERVER.host = nametoip(SERVERNAME);
      }
    }
    argc --;
    argv++;
  }
  CLIENT.port = clientport;
  SERVER.port = serverport;
  if (IP_EQUAL(ipaddr, SERVER.host)) {
    xcreateprocess(server, 5, 0);
  }
  if (IP_EQUAL(ipaddr, CLIENT.host)) {
    xcreateprocess(client, 6, 0);
  }
}

null(s,m,length)
int s, length;
char *m;
{
}

clientdemux(s, m, length)
int s, length;
char *m;
{
  time now, total;
  gotone = 1;
  if (++count < TRIPS) {
    xpush(s, m, length, (char *)0, (int *)0); 
  } else {
    xgettime(&now);
    subtime(&starttime, &now, &total);
    printf("len = %4d, %d trips: %6d.%-6d\n", 
      length, TRIPS, total.sec, total.usec);
#ifdef PROFILE
	endProfile();
#endif
  }
}

serverdemux(s, m, length)
int s, length;
char *m;
{
  xpush(s, m, length, 0, 0);
}

subtime(t1, t2, t3)
time *t1, *t2, *t3;
{
  t3->sec = t2->sec - t1->sec;
  t3->usec = t2->usec - t1->usec;
  if (t3->usec < 0) {
    t3->usec += 1000000;
    t3->sec -= 1;
  }
}
