
/*
 * user.c
 *
 * This version becomes a client on one host and a server on another,
 * so that the end result is a system with a unique client and a unique server.
 *
 * Formatted for tabs = 4.
 */


#include "xkernel.h"
#include "ip.h"
#include "util.h"
#include "rpcTypes.h"
#include "spc.h"
#include "site.h"




typedef struct{
	unsigned	requestId;
	int			clntProtl;
}Request;


typedef struct{
	unsigned	requestId;
	int			clntProtl;
	SrvrId		srvrId;
}Reply;


#define REPLY_BUF_SZ		100



/* a particular service to be requested and provided */
#define SERVICE_SRVR_ID	3

IPhost	ServiceIpHost;
IPhost	ClntIpHost;




typedef struct {
	int sec, usec;
}Time;




#define CALLS_PER_TEST	2
#define NUM_TESTS		1




#define DELAY			2000





client()
{
int		clntProtl;
int		null();
int		spcProtl;
Part	spcPart[3];
SPCaddr	localSpcAd;
SPCaddr	remoteSpcAd;
int		spcSessn;
int		testNum, callNum;
Time	startTime, finishTime, totalTime;
Request	request;
char	replyBuf[REPLY_BUF_SZ];
int		replySz;
Reply*	replyPtr;
int		pushRetVal;


	printf("USER: ON THIS HOST I PLAY RPC CLIENT\n");

	/* make the client into a protocol; null interface since just calls push */
	clntProtl = xcreateprotl( null, null, null );

	/* open an spc sessn for a particular service */
	spcProtl = xgetprotlbyname("spc");
	localSpcAd.srvr_host = ClntIpHost;
	localSpcAd.srvrId = (SrvrId) NULL;
	spcPart[0].address = (char*) &localSpcAd;
	spcPart[0].length = sizeof( localSpcAd );
	remoteSpcAd.srvr_host = ServiceIpHost;
	remoteSpcAd.srvrId = SERVICE_SRVR_ID;
	spcPart[1].address = (char*) &remoteSpcAd;
	spcPart[1].length = sizeof( remoteSpcAd );
	spcPart[2].address = (char*) 0;
	spcPart[2].length = 0;
	spcSessn = xopen( clntProtl, spcProtl, spcPart );
	printf("client: done opening a spc sessn\n");

	/* execute a series of timed tests,
	 * each of which is a series of calls/pushes on the spc sessn.
	 */
	for( testNum = 0; testNum < NUM_TESTS; testNum++ ){

		printf("Starting test %d comprising %d calls\n",testNum,CALLS_PER_TEST);
		xgettime( &startTime );

		/* execute a series of calls/pushes */
		for( callNum = 0; callNum < CALLS_PER_TEST; callNum++ ){
			request.requestId = callNum;
			request.clntProtl = clntProtl;
			replySz = REPLY_BUF_SZ;
			pushRetVal = xpush( spcSessn, (char*)&request, sizeof(request),
									&replyBuf[0], &replySz );
			if( pushRetVal < 0 ){
				printf("RPC CLIENT: RPC CALL FAILED, ERR=%d\n",pushRetVal);
			}else if( replySz != sizeof( Reply ) ){
				printf("RPC CLIENT: REPLY WRONG SIZE (%d)\n",replySz);
			}else{
				replyPtr = (Reply*) replyBuf;
				if( replyPtr->clntProtl != clntProtl ){
					printf("RPC CLIENT: GOT REPLY TO SOMEONE ELSE'S CALL\n");
				}else if( replyPtr->requestId != callNum ){
					printf("RPC CLIENT: GOT REPLY TO DIFF REQUEST (#%d)\n",
													replyPtr->requestId);
 				}else if( replyPtr->srvrId != SERVICE_SRVR_ID ){
 					printf("RPC CLIENT: GOT REPLY FROM WRONG SERVICE\n");
				}else{
					printf("RPC CLIENT: GOT GOOD REPLY\n");
				}
			}
		} /* end for callNum */

		xgettime( &finishTime );
		subtime( &startTime, &finishTime, &totalTime );
		printf("%d trips took %6d.%-6d\n",
							CALLS_PER_TEST, totalTime.sec, totalTime.usec);

		xpause( DELAY );

	} /* end for testNum */

}




server()
{
int		server_demux();
int		null();
int		srvrProtl;
int		spcProtl;
Part	spcPart[2];
SPCaddr	localSpcAd;


	printf("USER: ON THIS HOST I PLAY RPC SERVER\n");

	srvrProtl = xcreateprotl( server_demux, null, null );

	spcProtl = xgetprotlbyname( "spc" );

	localSpcAd.srvr_host = ServiceIpHost;
	localSpcAd.srvrId = SERVICE_SRVR_ID;
	spcPart[0].address = (char*) &localSpcAd;
	spcPart[0].length = sizeof( localSpcAd );
	spcPart[1].address = (char*) 0;
	spcPart[1].length = 0;
	(void) xopenenable( srvrProtl, spcProtl, spcPart );

	/* any further server activity will happen when server_demux is called */
    printf("SERVER: JUST WAITING FOR MY DEMUX TO BE CALLED\n");
}




user(argc, argv)
int		argc;
char**	argv;
{
int		ipProtl;
IPhost	localIpHost;
IPhost	nametoip();
char*	ServiceHostName;


	printf("USER (RPC TEST)\n");

	ipProtl = xgetprotlbyname("ip");
	if( xcontrolprotl( ipProtl, MYADDR, &localIpHost, sizeof(IPhost))
													!= sizeof(IPhost)){
		printf("Cannot get local IP addr\n");
		return;
	}
	printf("My IP addr = %d.%d.%d.%d\n",
				localIpHost.a,localIpHost.b,localIpHost.c,localIpHost.d);

	if( argc > 1 ){
		if( ! strncmp( argv[1], "-s", 2 ) ){
			/* boot cmd looks like "bxfoo -s", means this host has server */
			ServiceIpHost = localIpHost;
			ServiceHostName = malloc(24);
			iptoname( ServiceIpHost, ServiceHostName );
		}else if( ! strncmp( argv[1], "-c", 2 ) ){
			/* boot cmd looks like "bxfoo -c<serverhost>",
			 * means this host has client, <serverhost> has the server.
			 */
			ClntIpHost = localIpHost;
			ServiceHostName = &argv[1][2];
			ServiceIpHost = nametoip( ServiceHostName );
			printf("user: ServiceIpHost = %d.%d.%d.%d\n",ServiceIpHost.a,
						ServiceIpHost.b,ServiceIpHost.c,ServiceIpHost.d);
		}
		argc--;
		argv++;
	}else{
		printf("DON'T KNOW WHICH HOST PLAYS WHICH ROLE (SERVER/CLIENT)\n");
		return;
	}

	if(IP_EQUAL(localIpHost, ServiceIpHost)) {
		xcreateprocess(server, 5, 0);
	}else{
		xcreateprocess(client, 6, 0);
	}
}




null(s,m,length)
int s, length;
char *m;
{
}





server_demux( spcSessn, msgString, msgSz )
int		spcSessn;
char*	msgString;
int		msgSz;
{
Reply		reply;
Request*	requestPtr;


	printf("SERVER DEMUX\n");

	requestPtr = (Request*) msgString;

	printf("SERVER DEMUX: I SUPPLY SERVICE SRVRID=%d\n",SERVICE_SRVR_ID);

	reply.requestId = requestPtr->requestId;
	reply.clntProtl = requestPtr->clntProtl;
	reply.srvrId = SERVICE_SRVR_ID;

	xpush( spcSessn, (char*)&reply, sizeof( reply ), 0, 0);
}





subtime(t1, t2, t3)
Time *t1, *t2, *t3;
{
	t3->sec = t2->sec - t1->sec;
	t3->usec = t2->usec - t1->usec;
	if (t3->usec < 0) {
		t3->usec += 1000000;
		t3->sec -= 1;
	}
}

