h19274
s 00023/00012/00019
d D 1.3 91/01/10 11:25:45 llp 3 2
c Prepared for 3.1 Distribution
e
s 00001/00001/00030
d D 1.2 89/11/06 15:35:01 norm 2 1
c Fixed the definition of abort
e
s 00031/00000/00000
d D 1.1 89/10/24 13:46:10 norm 1 0
c date and time created 89/10/24 13:46:10 by norm
e
u
U
f e 0
t
T
I 1
/* 
D 3
 * %W%  %G%
E 3
I 3
 * assert.h
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
E 3
 */
I 3

E 3
#ifndef assert_h
#define assert_h
#ifdef XSIMUL
#ifndef FILE
#include <stdio.h>
#endif
D 3
#define PRINT fprintf(stderr,
E 3
I 3
#define PRINT(A,B,C) fprintf(stderr, (A), (B), (C))
#define assertMessage "Assertion failed: file %s, line %d\n"
E 3
#else
I 3
#ifdef USER
#define assertMessage "Assertion failed: file %s, line %d\n"
#define PRINT(A,B,C) printf((A), (B), (C))
#define abort() xexit()
#else
E 3
D 2
#define abort() breakpoint()
E 2
I 2
#define abort() Kabort("abort")
E 2
D 3
#define PRINT printf(
E 3
I 3
#define PRINT(A,B,C) printf((A), (B), (C))
extern char assertMessage[];
E 3
#endif
I 3
#endif
E 3

# ifdef lint
D 3
#  define assert(ex) {int assert__x_; assert__x_ = (ex); assert__x_ = assert__x_;}
#  define _assert(ex) {int assert__x_; assert__x_ = (ex); assert__x_ = assert__x_;}
E 3
I 3
   extern int assert__x_;
#  define assert(ex) (assert__x_ = (ex), assert__x_ = assert__x_ )
#  define _assert(ex)(assert__x_ = (ex), assert__x_ = assert__x_ )
E 3
# else
#  ifndef NDEBUG
D 3
extern char assertMessage[];
#   define _assert(ex) {if (!(ex)){PRINT\
     assertMessage, __FILE__, __LINE__); abort();}}
#   define assert(ex) {if (!(ex)){PRINT\
     assertMessage, __FILE__, __LINE__);abort();}}
E 3
I 3
#   define _assert(ex) ((ex) ? 1 : (PRINT(assertMessage, __FILE__, __LINE__), abort()))
#   define assert(ex)  ((ex) ? 1 : (PRINT(assertMessage, __FILE__, __LINE__), abort()))
E 3
#  else
D 3
#   define _assert(ex) ;
#   define assert(ex) ;
E 3
I 3
#   define _assert(ex) 1
#   define assert(ex) 1
E 3
#  endif
# endif
#endif
E 1
