/*
 * pmap4.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#include <rpc/rpc.h>
#include "xkernel.h"
#include "ip.h"
#include "udp.h"
#include "sun_rpc.h"
#include "pmap.h"
#include "pmap_internal.h"

static XObj SELF=0;
#define SUNRPC SELF->down[0]
#define PMAP4 SELF
static Msg null_msg={0,0};
int tracepmap4p=0;

static pmap4_instantiateprotl(self) 
XObj self;
{
  TRACE0(pmap4p, 1, "PMAP4 instanciateprotl");

  if (SELF) {
    Kabort("SUN Portmapper 4: can't instanciate twice");
  }
  SELF = self;
  return 0;
}


static pmap4_init(self)
XObj self;
{

  Part part[2];
  SUNRPCaddr server;
  IPhost myipaddr;
  

  if (x_controlprotl(SUNRPC, GETMYADDR, (char *)&myipaddr, 
		     sizeof myipaddr) < 0) {
    printf("Can't find my IP addr\n");
    return(-1);
  }


  /* create address */
  server.prog = PMAP_PROG;
  server.vers = PMAP_VERS;
  server.proc = PMAPPROC_DUMP;
  server.prot = 17;
  server.host.port = PMAP_PORT;  
  server.host.host = myipaddr;;
 
  init_partlist(part, 1, SUNRPCaddr); 
  set_part(part, 0 , server);
  x_openenable(PMAP4, SUNRPC, part);
}


static pmap4_demux(self,s, msg)
XObj 	self;
XObj	s;
Msg msg;
{
  char *buf;
  int len;
  int len2;
  int hlp;
  PMAP_ARGS args;
  int *results;
  Msg msg2;
  
  /* pmap dump not implemented */
 

  return(0);
}

static pmap4_opendone(self,s,part)
XObj self;
XObj s;
Part part;
{
  TRACE0(pmap4p,7,"--->pmap4_opendone");
}

pmap4_getproc(p,type)
XObj p;
XObjType type;
{
  if (type == Protocol) {
    p->instantiateprotl = pmap4_instantiateprotl;
    p->init = pmap4_init;
  } else {
    p->instantiateprotl = noop;
    p->init = noop;
  }
  p->close = noop;
  p->control = noop;
  p->push = noop; 
  p->pop = noop;
  p->open = (Pfi) noop;
  p->openenable = noop;
  p->opendone = pmap4_opendone;
  p->closedone = noop;
  p->opendisable = noop;
  p->demux = pmap4_demux;
  p->getproc = pmap4_getproc;
}

