h33060
s 00533/00000/00000
d D 1.1 91/01/10 11:48:35 llp 1 0
c date and time created 91/01/10 11:48:35 by llp
e
u
U
f e 0
t
T
I 1
/* 
 * stable_store.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#include "xkernel.h"
#include "ip.h"
#include "stable_store.h"
#include "stable_store_internal.h"

int     tracestable_storep;


stable_store_instantiateprotl(self)
     XObj    self;
{
  Pstate  *pstate;
  
  TRACE0(stable_storep, 3, "stable_store intantiateprotl");
  assert(x_is_protocol(self));
  
  self->state = malloc(sizeof(Pstate));
  
}

stable_store_init(self)
     XObj    self;
{
  IPaddr  myipaddr, rem_addr;
  Pstate  *pstate;
  XObj    ip;
  Part    part[3];
  
  TRACE0(stable_storep, 3, "stable_store init");
  assert(x_is_protocol(self));
  
  pstate = (Pstate *)self->state;
  
  pstate->ipProtoNum = IP_NUM;
  pstate->smap = map_create(25, sizeof(SS_addr));
  pstate->srver_adr.a = 192;
  pstate->srver_adr.b = 12;
  pstate->srver_adr.c = 69;
  pstate->srver_adr.d = 45;
  
  /* COMPLETE THIS
     pstate->bootId =
     */
  
  pstate->freeList = NULL;
  InitSemaphore(&pstate->listProt, 1);
  
  ip = x_getprotlbyname("ip");
  x_controlprotl(self->down[0], GETMYADDR, &(myipaddr.host), sizeof(IPhost));
  myipaddr.protocolnum = pstate->ipProtoNum;
  TRACE4(stable_storep, 3, "stable_store: my IPaddress is %d.%d.%d.%d",
	 myipaddr.host.a, myipaddr.host.b, myipaddr.host.c, myipaddr.host.d);
  
  
  if (sameIPhost(myipaddr.host, pstate->srver_adr)) {
    TRACE0(stable_storep, 1, "I am the server\n");
    init_partlist(part, 1, IPaddr);
    set_part(part, 0, myipaddr);
    pstate->amServer = TRUE;
    if (x_openenable(self, self->down[0], part) < 0) {
      printf("stable_store_init: can't openenable transport protocol\n");
      free((char *)pstate);
      return -1;
    }
  }
  else {
    TRACE0(stable_storep, 1, "I am a client\n");
    init_partlist(part, 2, IPaddr);
    set_part(part, 0, myipaddr);
    rem_addr.host = pstate->srver_adr;
    rem_addr.protocolnum = pstate->ipProtoNum;
    set_part(part, 1, rem_addr);
    pstate->amServer = FALSE;
    if ((pstate->transpSess = x_open(self, self->down[0], part)) == ERR_XOBJ) {
      printf("stable_store_init: cannot open transport session\n");
      return -1;
    }
  }
  
  return 0;
  
}


XObj stable_store_open(self, hlp, p)
     XObj  	self;
     XObj	hlp;
     Part	*p;
{
  Pstate  *pstate;
  XObj    ss_s;
  Sstate  *sstate;
  
  TRACE0(stable_storep, 3, "stable_store open");
  assert(x_is_protocol(self));
  assert(x_is_protocol(hlp));
  if (!p) {
    TRACE0(stable_storep, 5, "Bad participant set");
    x_errno = BAD_ADDR;
    return(ERR_XOBJ);
  }
  
  pstate = (Pstate *)self->state;
  
  if ((ss_s = (XObj)map_resolve(pstate->smap,(char *)p[0].address)) != ERR_XOBJ)
    ss_s->rcnt++;
  else {
    ss_s = x_createsession(hlp, self, 1);
    ss_s->numdown = 1;
    ss_s->down[0] = pstate->transpSess;
    ss_s->binding = (Bind)map_bind(pstate->smap, (char *)p[0].address,
				   (int)ss_s);
    sstate = (Sstate *)malloc(sizeof(Sstate));
    
    sstate->vmId = *(SS_addr *)p[0].address;
    
    ss_s->rcnt = 1;
    ss_s->state = (char *)sstate;
  }
  TRACE1(stable_storep, 4, "stable_store open returns %x", ss_s);
  return(ss_s);
  
}


stable_store_controlsessn(s, opcode, buf, len)
     XObj    s;
     int     opcode, len;
     char    *buf;
{
  SS_header *hdr, *hdr1, msgHeader;
  Sstate  *sstate;
  Msg     msg;
  Semaphore *waitS;
  char    *reply;
  int inq_reply;
  int tmp;
  
  assert(x_is_session(s));
  
  if (s <= (XObj)0) {
    x_errno = BAD_ADDR;
    return(-1);
  } else {
    opcode = opcode % (SS_CTL*MAXOPS);	/* turn ctl op into protocol op */
    switch (opcode) {
    case INQUIRE:
    case READ:
    case WRITE:
    case INIT_V:
    case APPEND:
    case READALL:
    case READSIZE:
      sstate = (Sstate *)s->state;
      
      hdr = &(msgHeader);
      hdr->vmId = sstate->vmId;
      /*
	printf("got vmId is %d   %d %d %d %d\n", hdr->vmId.a, hdr->vmId.b.a, hdr->vmId.b.b, hdr->vmId.b.c, hdr->vmId.b.d);
	*/
      hdr->opCode = opcode;
      P(&((Pstate *)(s->myprotl->state))->listProt);
      if ((hdr->wait = ((Pstate *)(s->myprotl->state))->freeList) == NULL) {
	hdr->wait = (WaitStruct *)malloc(sizeof(WaitStruct));
	hdr->wait->next = NULL;
      }
      else
	((Pstate *)(s->myprotl->state))->freeList = 
	  ((Pstate *)(s->myprotl->state))->freeList->next;
      waitS = &hdr->wait->wait;
      V(&((Pstate *)(s->myprotl->state))->listProt);
      InitSemaphore(waitS, 0);
      
      msg_make_allstack(msg, MSG_SSIZE, buf, len);
      /*
	printf("bef cp vmId is %d   %d %d %d %d\n", hdr->vmId.a, hdr->vmId.b.a, hdr->vmId.b.b, hdr->vmId.b.c, hdr->vmId.b.d);
	*/
      hdr1 = (SS_header *)msg_push(msg, HEADER_LEN);
      *hdr1 = *hdr;
      /*
        bcopy(hdr, msg_push(msg, HEADER_LEN), HEADER_LEN);
	*/
      x_push(s->down[0], msg, (Msg *)0);
      TRACE0(stable_storep, 3, "stable_store_controlsessn: going to sleep");
      P(waitS);       /* will be woken up by reply message    */
      TRACE0(stable_storep, 3, "stable_store_controlsessn: waking up");
      
      reply = msg_top(hdr->wait->msg, HEADER_LEN);
      if ((opcode == READ) || (opcode == READALL) || (opcode == INQUIRE) || (opcode == READSIZE))
	bcopy(reply + HEADER_LEN, buf, msg_len(hdr->wait->msg)-HEADER_LEN);
      msg_free(hdr->wait->msg);
      P(&((Pstate *)(s->myprotl->state))->listProt);
      ((SS_header *)reply)->wait->next = 
	((Pstate *)(s->myprotl->state))->freeList;
      ((Pstate *)(s->myprotl->state))->freeList = 
	((SS_header *)reply)->wait;
      V(&((Pstate *)(s->myprotl->state))->listProt);
      
      break;
      
    default:
      Kabort("stable_store_controlsessn: illegal opcode");
      /* NOTREACHED */
    }
    return 0;
  }
  
}


stable_store_controlprotl(self,opcode, buf, len)
     XObj    self;
     int     opcode, len;
     char    *buf;
{
  
  TRACE0(stable_storep, 3, "stable_store_controlprotl");
  Kabort("stable_store_controlprotl: should not be invoked");
  /* NOTREACHED */
  
}


stable_store_openenable(self, hlp, p)
     XObj	self;
     XObj	hlp;
     Part	*p;
{
  
  TRACE0(stable_storep, 3, "stable_store_openenable");
  Kabort("stable_store_openable: should not be invoked");
  /* NOTREACHED */
  
}


stable_store_closesessn(s)
     XObj    s;
{
  Pstate *pstate;
  
  assert(x_is_session(s));
  TRACE1(stable_storep, 3, "stable_store close of session %x", s);
  if (--s->rcnt > 0) {
    return 0;
  }
  pstate = (Pstate *) s->myprotl->state;
  map_unbindbinding(pstate->smap, s->binding);
  if (s->state > ST_BROKEN) {
    x_close(s->down[0]);
  }
  x_destroysession(s);
  return 0;
  
}


stable_store_closeprotl(self)
     XObj self;
{
  Pstate *pstate;
  
  assert(x_is_protocol(self));
  if (((self->rcnt)) > 0) 
    return;
  pstate = (Pstate *) self->state;
  map_close(pstate->smap);
  free((char *)pstate);
  
}


stable_store_push(s, msg, rmsg_ptr)
     XObj	s;
     Msg	msg;
     Msg	*rmsg_ptr;
{
  TRACE0(stable_storep, 3, "stable_store push");
  Kabort("stable_store_push: should not be invoked");
  /* NOTREACHED */
  
}


stable_store_demux(self,transp_s, dg)
     XObj	self;
     XObj	transp_s;
     Msg	dg;
{
  Pstate  *pstate;
  SS_header *hdr;
  XObj    s;
  Sstate  *sstate;
  unsigned int msgLen;
  char *msgStart, *msgPtr;
  
  assert(x_is_session(transp_s));
  assert(x_is_protocol(self));
  
  pstate = (Pstate *)self->state;
  hdr = (SS_header *)msg_top(dg, HEADER_LEN);
  
  
  msgLen = msg_len(dg);
  msgStart = msg_top(dg, msgLen);
  msgPtr = msgStart + HEADER_LEN;
  
  if ((s = (XObj)map_resolve(pstate->smap, (char *)(&hdr->vmId))) != ERR_XOBJ) {
    TRACE1(stable_storep, 3, "Popping to existing session %x", s);
    if (hdr->opCode == INQUIRE) {
      *(int *)(msgPtr + sizeof(MsgFmt)) = 1;
      ((SS_header *)msgStart)->opCode = ACK_INQUIRE;
      return(x_push(transp_s, dg, (Msg *)NULL));
    }
    return(x_pop(s, transp_s, dg));
  }
  else {
    if (hdr->opCode == INQUIRE) {
      *(int *)(msgPtr + sizeof(MsgFmt)) = 0;
      ((SS_header *)msgStart)->opCode = ACK_INQUIRE;
      return(x_push(transp_s, dg, (Msg *)NULL));
    }
    if (hdr->opCode != INIT_V) {
      printf("stable_store_demux: packet to non-existant session being dropped\n");
      printf("recd vmId is %d   %d %d %d %d\n", hdr->vmId.a, hdr->vmId.b.a, hdr->vmId.b.b, hdr->vmId.b.c, hdr->vmId.b.d);
      return 0;
    }
    if (pstate->amServer) {
      s = x_createsession(self, self, 1);
      s->numdown = 1;
      s->down[0] = transp_s;
      s->binding = (Bind)map_bind(pstate->smap, (char *)&hdr->vmId, (int)s);
      (char *)sstate = s->state = malloc(sizeof(Sstate));
      sstate->myvm = hdr->vmId;
      sstate->dataMap = map_create(50, 4);
      InitSemaphore(&sstate->dataProt, 1);
      sstate->vmId = hdr->vmId;
      return (x_pop(s, transp_s, dg));
    }
    else
      Kabort("stable_store_demux: client got init message");
    /* NOT REACHED */
  }
  
}


stable_store_pop(s, ds, dg)
     XObj	s, ds;
     Msg	dg;
{
  Sstate  *sstate;
  unsigned int   msgLen;
  int  opCode;
  char    *msgStart, *msgPtr;
  char    *dataArea;
  int     size, num;
  
  TRACE0(stable_storep, 3, "stable_store pop");
  assert(x_is_session(s));
  
  sstate = (Sstate *)s->state;
  
  msgLen = msg_len(dg);
  msgStart = msg_top(dg, msgLen); /* entire msg now on stack */
  msgPtr = msgStart + HEADER_LEN;
  
  opCode = ((SS_header *)msgStart)->opCode;
  switch (opCode) {
  case INIT_V:
    TRACE0(stable_storep, 3, "stable_store_pop: recd INIT_V");
    P(&sstate->dataProt);
    while (msgStart + msgLen != msgPtr) {
      dataArea = malloc((((MsgFmt *)msgPtr)->elempos) * (((MsgFmt *)msgPtr)->byteCount) + 2 * sizeof(int));
      if ((Bind)map_bind(sstate->dataMap,&((MsgFmt *)msgPtr)->varId,
			 (int)dataArea) == ERR_BIND) {
	TRACE0(stable_storep, 2, "stable_store_pop: variable already init'ed.");
	free(dataArea);
      }
      else {
	*(int *)dataArea = 0;
	*(int *)(dataArea + 4) = ((MsgFmt *)msgPtr)->byteCount;
      }
      msgPtr += sizeof(MsgFmt);
    }
    V(&sstate->dataProt);
    ((SS_header *)msgStart)->opCode = ACK_INIT;
    return(x_push(ds, dg, (Msg *)NULL));
    
  case READ:
    TRACE0(stable_storep, 3, "stable_store_pop: recd READ");
    P(&sstate->dataProt);
    while (msgStart + msgLen != msgPtr) {
      if ((dataArea = (char *)map_resolve(sstate->dataMap, 
					  &((MsgFmt *)msgPtr)->varId)) == (char *)ERR_XOBJ)
	printf("stable_store_pop: attempt to read un-init'ed variable %d\n", ((MsgFmt *)msgPtr)->varId);
      else {
	size = (*(int *)(dataArea + 4));
	bcopy(dataArea + 2 * sizeof(int) + size * 
	      ((MsgFmt *)msgPtr)->elempos, msgPtr + sizeof(MsgFmt),
	      size * (((MsgFmt *)msgPtr)->byteCount));
      }
      msgPtr += sizeof(MsgFmt) + size * ((MsgFmt *)msgPtr)->byteCount;
    }
    V(&sstate->dataProt);
    ((SS_header *)msgStart)->opCode = ACK_READ;
    return(x_push(ds, dg, (Msg *)NULL));
    
  case WRITE:
    TRACE0(stable_storep, 3, "stable_store_pop: recd WRITE");
    P(&sstate->dataProt);
    while (msgStart + msgLen != msgPtr) {
      if ((dataArea = (char *)map_resolve(sstate->dataMap, 
					  &((MsgFmt *)msgPtr)->varId)) == (char *)ERR_XOBJ)
	printf("stable_store_pop: attempt to write un-init'ed variable\n");
      else {
	size = (*(int *)(dataArea + 4));
	bcopy(msgPtr + sizeof(MsgFmt), dataArea + 2 * sizeof(int) +
	      size * ((MsgFmt *)msgPtr)->elempos,
	      size * ((MsgFmt *)msgPtr)->byteCount);
      }
      msgPtr += sizeof(MsgFmt) + size * ((MsgFmt *)msgPtr)->byteCount;
    }
    V(&sstate->dataProt);
    ((SS_header *)msgStart)->opCode = ACK_WRITE;
    return(x_push(ds, dg, (Msg *)NULL));
    
  case APPEND:
    TRACE0(stable_storep, 3, "stable_store_pop: recd APPEND");
    P(&sstate->dataProt);
    while (msgStart + msgLen != msgPtr) {
      if ((dataArea = (char *)map_resolve(sstate->dataMap, 
					  &((MsgFmt *)msgPtr)->varId)) == (char *)ERR_XOBJ)
	printf("stable_store_pop: attempt to write un-init'ed variable %d\n", ((MsgFmt *)msgPtr)->varId);
      else {
	num = *(int *)dataArea;
	size = (*(int *)(dataArea + 4));
	bcopy(msgPtr + sizeof(MsgFmt), dataArea + 2 * sizeof(int) +
	      size * num, ((MsgFmt *)msgPtr)->byteCount * size);
	*(int *)dataArea = num + ((MsgFmt *)msgPtr)->byteCount;
      }
      msgPtr += sizeof(MsgFmt) + ((MsgFmt *)msgPtr)->byteCount * size;
    }
    V(&sstate->dataProt);
    ((SS_header *)msgStart)->opCode = ACK_APPEND;
    return(x_push(ds, dg, (Msg *)NULL));
    
  case READALL:
    TRACE0(stable_storep, 3, "stable_store_pop: recd READALL");
    P(&sstate->dataProt);
    if ((dataArea = (char *)map_resolve(sstate->dataMap, 
					&((MsgFmt *)msgPtr)->varId)) == (char *)ERR_XOBJ)
      printf("stable_store_pop: attempt to read un-init'ed variable\n");
    else {
      num = *(int *)dataArea;
      size = (*(int *)(dataArea + 4));
      bcopy(dataArea, msgPtr + sizeof(MsgFmt), sizeof(int));
      bcopy(dataArea + 2 * sizeof(int), msgPtr + sizeof(MsgFmt) + sizeof(int),
	    size * num);
    }
    V(&sstate->dataProt);
    ((SS_header *)msgStart)->opCode = ACK_READALL;
    return(x_push(ds, dg, (Msg *)NULL));
  case READSIZE:
    TRACE0(stable_storep, 3, "stable_store_pop: recd READSIZE");
    P(&sstate->dataProt);
    if ((dataArea = (char *)map_resolve(sstate->dataMap,
					&((MsgFmt *)msgPtr)->varId)) == (char *)ERR_XOBJ)
      printf("stable_store_pop: attempt to readsize un-init'ed variable\n");
    else {
      num = *(int *)dataArea;
      bcopy(dataArea, msgPtr + sizeof(MsgFmt), sizeof(int));
    }
    V(&sstate->dataProt);
    ((SS_header *)msgStart)->opCode = ACK_READSIZE;
    return(x_push(ds, dg, (Msg *)NULL));
    
  case ACK_READ:
  case ACK_INIT:
  case ACK_WRITE:
  case ACK_APPEND:
  case ACK_READALL:
  case ACK_INQUIRE:
  case ACK_READSIZE:
    TRACE0(stable_storep, 3, "stable_store_pop: recd ACK_READALL/ACK_INIT/ACK_WRITE/ACK_READ/ACK_APPEND/ACK_READSIZE");
    ((SS_header *)msgStart)->wait->msg = dg;
    V(&((SS_header *)msgStart)->wait->wait);
    return 1;
    
  default:
    Kabort("stable_store_pop: Illegal opCode in message");
    /* NOT REACHED */
  }
  
}


stable_store_getproc(p, type)
     XObj p;
     XObjType type;
{
  
  if (type == Protocol) {
    p->instantiateprotl = stable_store_instantiateprotl;
    p->init = stable_store_init;
    p->close = stable_store_closeprotl;
    p->push = noop;
    p->pop = noop;
    p->control = stable_store_controlprotl;
  } else {
    p->push = stable_store_push;
    p->pop = stable_store_pop;
    p->instantiateprotl = noop;
    p->init = noop;
    p->control = stable_store_controlsessn;
    p->close = stable_store_closesessn;
  }
  p->open = (Pfi) stable_store_open;
  p->openenable = stable_store_openenable;
  p->opendone = noop;
  p->closedone = noop;
  p->opendisable = noop;
  p->demux = stable_store_demux;
  p->getproc = stable_store_getproc;
}
E 1
