h49625
s 00011/00013/00175
d D 1.2 91/01/10 11:45:33 llp 2 1
c Prepared for 3.1 Distribution
e
s 00188/00000/00000
d D 1.1 90/12/03 14:52:22 menze 1 0
c date and time created 90/12/03 14:52:22 by menze
e
u
U
f e 0
t
T
I 1
/*
 * pmap2.c
 *
 * x-kernel v3.1	12/10/90
 *
D 2
 * Copyright 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
I 2
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
 */

#include <rpc/rpc.h>
D 2
#include "upi.h"
#include "debug.h"
#include "system.h"
#include "process.h"
E 2
I 2
#include "xkernel.h"
E 2
#include "ip.h"
#include "udp.h"
#include "sun_rpc.h"
#include "pmap.h"
#include "pmap_internal.h"

int *pmapproc_unset();

static XObj SELF=0;
#define SUNRPC SELF->down[0]
#define PMAP2 SELF
int tracepmap2p = 0;

static pmap2_instantiateprotl(self) 
XObj self;
{
  TRACE0(pmap2p, 1, "PMAP2 instanciateprotl");

  if (SELF) {
    Kabort("SUN Portmapper 2: can't instanciate twice");
  }
  SELF = self;
  return 0;
}

static pmap2_init(self)
XObj self;
{

  Part part[2];
  SUNRPCaddr server;
  IPhost myipaddr;


D 2
  if (x_controlprotl(SUNRPC, MYADDR, (char *)&myipaddr, sizeof myipaddr) < 0) {
E 2
I 2
  if (x_controlprotl(SUNRPC, GETMYADDR, (char *)&myipaddr, 
		     sizeof myipaddr) < 0) {
E 2
    printf("Can't find my IP addr\n");
    return(-1);
  }


  /* create address */
  server.prog = PMAP_PROG;
  server.vers = PMAP_VERS;
  server.proc = PMAPPROC_UNSET;
  server.prot = 17;
  server.host.port = PMAP_PORT;  
  server.host.host = myipaddr;
  
  init_partlist(part, 1, SUNRPCaddr); 
  set_part(part, 0, server);
  x_openenable(PMAP2, SUNRPC, part);
  return(0);
}


static pmap2_demux(self,s, msg)
XObj	self,s;
D 2
MSG msg;
E 2
I 2
Msg msg;
E 2
{
  char *buf;
  int len;
  char buf2[100];
  int len2;
  PMAP_ARGS args;
  int *results;
D 2
  MSG msg2;
E 2
I 2
  Msg msg2;
E 2
  

  /* externalize message */
  len = msg_len(msg);
  buf = (char *) malloc(len + 2);
  msg_externalize(msg,buf);


  /* check authentication */


  /* decode arguments */
  if (decode_xdr(xdr_pmap,buf,len,&args) == -1) {;
D 2
    x_controlsessn(s,SVCGARBAGE_ARGS,0,0);
E 2
I 2
    x_controlsessn(s, SUNRPC_SVCGARBAGEARGS,0,0);
E 2
    return(-1);
  }
  

  /* call procedure */ 
  results = pmapproc_unset(&args);
  

  /* xdr results */
  if (results != 0) { 
    if ((len2 = encode_xdr(xdr_int,buf2,100,results)) == -1) {;
D 2
      x_controlsessn(s,SVCGARBAGE_ARGS,0,0);
E 2
I 2
      x_controlsessn(s, SUNRPC_SVCGARBAGEARGS,0,0);
E 2
      free(results);
      return(-1);
    } else {
      free(results);
    }
  } else {
D 2
    x_controlsessn(s,SVCSYSTEM_ERR,0,0);
E 2
I 2
    x_controlsessn(s, SUNRPC_SVCSYSTEMERR,0,0);
E 2
    return(-1);
  }

  /* set authentication */

  IFTRACE(pmap2p,7) {
  printf("server_demux: len2 = %d buf2 = %d\n",len2,buf2);
  print_xdr(buf2,len);
  }

  /* internalize message */
  msg_make_allstack(msg2,256,buf2,len2);
  
  /* reply to call */
D 2
  x_push(s,msg2,(MSG *)0);
E 2
I 2
  x_push(s,msg2,(Msg *)0);
E 2
  free(buf);
  return(0);
}

static pmap2_opendone(self,s,part)
XObj s,self;
Part part;
{
  TRACE0(pmap2p,7,"--->pmap2_opendone");
}
static int *pmapproc_unset(args)
PMAP_ARGS *args;
{
  PMAP_EXT_ID ext_id;
  int int_id;
  int *reply;
  Bind binding;


  TRACE0(pmap2p,1,"pmap_unset: entered\n");
  ext_id.prog = args->prog;
  ext_id.vers = args->vers;
  ext_id.prot = IPPROTO_UDP;


  reply = (int *) malloc(sizeof(int));
  *reply = 0;
  int_id = -1;
  if (map_unbind(port_map,&ext_id,int_id) == -1) {
    TRACE0(pmap2p,3,"pmap_unset: no udp bind to unbind\n");
  } else {
    *reply = 1;
  }
  return(reply);
}


pmap2_getproc(p,type)
XObj p;
D 2
XobjType type;
E 2
I 2
XObjType type;
E 2
{
  if (type == Protocol) {
    p->instantiateprotl = pmap2_instantiateprotl;
    p->init = pmap2_init;
  } else {
    p->instantiateprotl = noop;
    p->init = noop;
  }
  p->close = noop;
  p->control = noop;
  p->push = noop; 
  p->pop = noop;
  p->open = (Pfi) noop;
  p->openenable = noop;
  p->opendone = pmap2_opendone;
  p->closedone = noop;
  p->opendisable = noop;
  p->demux = pmap2_demux;
  p->getproc = pmap2_getproc;
}

E 1
