h11554
s 00104/00000/00000
d D 1.1 91/01/10 11:10:17 llp 1 0
c date and time created 91/01/10 11:10:17 by llp
e
u
U
f e 0
t
T
I 1
/* 
 * profile.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#include "process.h"
#include "memory.h"
#include "trap.h"

#define TICKSIZE 8
unsigned short *tickInfo = NULL;
int tickSize = TICKSIZE;
static char *profStart, *profEnd;
static unsigned short tickMissed;
static int nTicks;
static Pfi handler;
static Aspace *handlerAspace;

profilePutArgs(args, p)
int *args;
char *p;
{
  *args++ = (int) profStart;
  *args++ = (int) profEnd;
  *args++ = tickMissed;
  *args++ = nTicks;
  *args = (int) p;
  bcopy((char *)tickInfo, p, nTicks * sizeof(unsigned short));
  handler = NULL;
  handlerAspace = NULL;
  free((char *) tickInfo);
  tickInfo = NULL;
}

callBackUser()
{
  CallUserRoutine(handlerAspace, handler, 5,
    nTicks * sizeof(unsigned short), profilePutArgs, (Pfi)0, 0, 0, 0, 0);
}

#define PF_START	1
#define PF_END		0
#define PF_USER		2
#define PF_KERNEL	0

initProfile(flags, f)
int flags;
Pfi f;
{
  extern char etext;
  int nBytes;
  int doStart = flags & PF_START, doUser = flags & PF_USER;
  if (doStart) {
    if (doUser) {
      extern char BeginUser, EndUser;
      unsigned realUserSize = (unsigned) (&EndUser - &BeginUser);
      profStart = (char *) ASPACE_START;
      profEnd   = profStart + realUserSize;
    } else {
      profStart = (char *) KERNEL_START;
      profEnd   = &etext;
    }
    if (tickInfo) {
      free((char *) tickInfo);
      tickInfo = NULL;
    }
    tickMissed = 0;
    nBytes = profEnd - profStart;
    TRACE3(tick, 1, "Profile: from %X to %X, %d bytes", profStart, profEnd, nBytes);
#define MAXTICKS ((4 * PAGE_SIZE - 1024) / sizeof(unsigned short))
    tickSize = (nBytes + MAXTICKS - 1) / MAXTICKS;
    tickSize = (tickSize + 1) & ~1;
    TRACE1(tick, 1, "Profile: %d bytes per tick", tickSize);
    nTicks = (nBytes + tickSize - 1) / tickSize;
    TRACE1(tick, 1, "Profile: %d ticks", nTicks);
    profEnd = profStart + nTicks * tickSize;
    TRACE1(tick, 1, "Profile:  rounded profEnd to %x", profEnd);
    tickInfo = (unsigned short *) calloc(nTicks, sizeof(unsigned short));
    handler = f;
    handlerAspace = GetAddressableAspace();
  } else if (tickInfo) {
    CreateKernelProcess(callBackUser, 1, 0);
  }
}

Tick(pc)
char *pc;
{
  register unsigned short *bucket;
  int index;
  if (!tickInfo) return;
  if (pc < profStart || profEnd < pc) {
    TRACE1(tick, 3, "Tick at %X missed", pc);
    tickMissed++;
  } else {
    index = ((int)(pc - profStart)) / tickSize;
    bucket = &tickInfo[index];
    (*bucket)++;
    TRACE2(tick, 3, "Tick at %X, index %d", pc, index);
  }
}
E 1
