h37902
s 00046/00000/00000
d D 1.1 91/01/10 11:10:14 llp 1 0
c date and time created 91/01/10 11:10:14 by llp
e
u
U
f e 0
t
T
I 1
/* 
 * memory.h
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#ifndef memory_h
#define memory_h

#ifndef ms_memory_h
#include "ms_memory.h"
#endif

/*
 * Aspace Descriptor Record
 */
typedef struct _Aspace {
  struct _Aspace	*next;
  struct _Aspace	*prev;
  Ms_AspaceState aspace_space;	/* Machine dependent descriptor of aspace */
} Aspace;

/*********************************************************
* Exported macros, functions, and variables
**********************************************************/

#define GetAddressableAspace()		AddressableAspace
#define SetAddressableAspace(as)	Ms_SetAddressableAspace(as)
#define GetAspaceSize(as)		Ms_GetAspaceSize(as)
#define SetAspaceSize(as,size)		Ms_SetAspaceSize(as,size)
#define	AllocateKernelPage()		Ms_AllocateKernelPage()
#define	AllocateUserPage()		Ms_AllocateUserPage()
#define	MapPage(old,new,protection)	Ms_MapPage(old,new,protection)

extern int InitMemory();
extern Aspace *CreateAspace();
extern int DeallocateAspace();
extern int FreePage();

extern Aspace *AddressableAspace;
extern Aspace *AspaceDescriptors;
extern unsigned long MaxAspaces;

#endif
E 1
