/* 
 * mapnet.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#include "ethernet.h"
#include "ip.h"
#include "arp.h"
#include "dns.h"

static Protl ARP, DNS;

IPhost ethtoip(e)
ETHhost e;
{
  ETHhost buf;
  IPhost ans;
  buf = e;
  if (!ARP) ARP = xgetprotlbyname("arp");
  if (xcontrolprotl(ARP, RRESOLVE, (char *)&buf, sizeof buf) < 0) {
    ans.a = ans.b = ans.c = ans.d = 0;
  } else {
    ans = *(IPhost *)&buf;
  }
  return ans;
}

void iptoname(i, s)
IPhost i;
char *s;
{
  struct resolve_result res;
  if (!DNS) DNS = xgetprotlbyname("dns");

  sprintf(res.name, "%d.%d.%d.%d", i.a, i.b, i.c, i.d);
  xcontrolprotl(DNS, RRESOLVE, (char *)&res, sizeof res);
  strcpy(s, res.name);
}

void ethtoname(e, s)
ETHhost e;
char *s;
{
  IPhost i;
  i = ethtoip(e);
  iptoname(i, s);
}

ETHhost iptoeth(iaddr)
IPhost iaddr;
{
  union {
    IPhost ipaddr;
    ETHhost  eaddr;
  } either;
  ETHhost ans;

  either.ipaddr = iaddr;
  if (!ARP) ARP = xgetprotlbyname("arp");
  if (xcontrolprotl(ARP, RESOLVE, (char *)&either, sizeof either) < 0) {
    ans.high = ans.mid = ans.low = 0;
  } else {
    ans = either.eaddr;
  } 
  return ans;
}

IPhost nametoip(s)
char *s;
{
  struct resolve_result res;
  IPhost ans;
  if (!DNS) DNS = xgetprotlbyname("dns");

  strcpy(res.name, s);
  if (xcontrolprotl(DNS, RESOLVE, (char *)&res, sizeof res) < 0) {
    ans.a = ans.b = ans.c = ans.d = 0;
  } else {
    ans = res.addr[0];
  }
  return ans;
}

ETHhost nametoeth(s)
char *s;
{
  IPhost ipaddr;
  ETHhost eaddr;

  ipaddr = nametoip(s);
  eaddr = iptoeth(ipaddr);
  return eaddr;
}
