/* 
 * scr.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#include "xkernel.h"
#include "scr.h"

int tracescrp;
static int ss_charsize = 0;
static XObj SCR;
static Sessn thesession = NULL;

scr_init(self)
XObj self;
{
  SCR = self;
}

/*ARGSUSED*/
Sessn scr_open(self, hlp, part)
XObj self, hlp;
Part *part;
{
  TRACE1(scrp, 3, "scr open hlp = %d", hlp);
  if (!thesession) {
    thesession = x_createsession(hlp, SCR, 0);
    thesession->state = NULL;
  }
  TRACE1(scrp, 3, "scr open returns %x", thesession);
  return(thesession);
}

/*ARGSUSED*/
scr_close(s)
Sessn s;
{
  /* do nothing */
}

/*ARGSUSED*/
scr_push(s, msg, rmsg_ptr)
Sessn s;
Msg msg;
Msg *rmsg_ptr;
{
  char *buf1, *buf2, *b;
  int len = msg_len(msg);
  buf1 = (char *) malloc((unsigned)(len+1));
  buf2 = (char *) malloc((unsigned)(len*8+1));
  msg_externalize(msg, buf1);
  buf1[len] = '\0';
  expand_tabs(buf1, buf2);
  TRACE1(scrp, 1, "scr push \"%s\"", buf2);
  b = buf2;
  if (ss_charsize) {
    while (*b) screen_putbigchar(ss_charsize+1, *b++);
  } else {
    while (*b) screen_putchar(*b++);
  }
  free(buf1);
  free(buf2);
}

/*ARGSUSED*/
scr_controlSessn(s, opcode, buf, len)
Sessn s;
int opcode, buf[2], len;
{
  switch (opcode) {
    case SCR_GOTO:
      screen_goto(buf[0], buf[1]);
      return 0;
    case SCR_GETSIZE:
      if (len != 2 * sizeof(int)) {
	x_errno = BUFFER_TOO_SMALL;
	return -1;
      }
      screen_getsize(&buf[0], &buf[1]);
      return 2 * sizeof(int);
    default:
      x_errno = INVALID_OPCODE;
      return -1;
  }
}

/*ARGSUSED*/
scr_controlprotl(self, opcode, buf, len)
XObj self;
int opcode, *buf, len;
{
  switch (opcode) {
    case SCR_GETSIZE:
      if (len != 2 * sizeof(int)) {
	x_errno = BUFFER_TOO_SMALL;
	return -1;
      }
      screen_getsize(&buf[0], &buf[1]);
      return 2 * sizeof(int);
    case SCR_GOTO:
      if (len != 2 * sizeof(int)) {
	x_errno = BUFFER_TOO_SMALL;
	return -1;
      }
      screen_goto(buf[0], buf[1]);
      return 0;
    case SCR_LINE:
      if (len != 4 * sizeof(int)) {
	x_errno = BUFFER_TOO_SMALL;
	return -1;
      }
      screen_line(buf[0], buf[1], buf[2], buf[3]);
      return 0;
    case SCR_BLT:
      if (len != 5 * sizeof(int)) {
	x_errno = BUFFER_TOO_SMALL;
	return -1;
      }
      screen_blt(buf[0], buf[1], buf[2], buf[3], buf[4]);
      return 0;
    case SCR_BITBLT:
      if (len != 6 * sizeof(int)) {
	x_errno = BUFFER_TOO_SMALL;
	return -1;
      }
      screen_bitblt(buf[0], buf[1], buf[2], buf[3], buf[4], buf[5]);
      return 0;
    case SCR_CHARSIZE:
      if (len != sizeof(int)) {
	x_errno = BUFFER_TOO_SMALL;
	return -1;
      }
      if (buf[0] < 0) {
	ss_charsize = 0;
      } else if (buf[0] > 4) {
	ss_charsize = 4;
      } else {
	ss_charsize = buf[0];
      }
      return sizeof(int);
    default:
      x_errno = INVALID_OPCODE;
      return -1;
  }
}

static noop() {}

scr_getproc(p,type)
XObj p;
XObjType type;
{
  if (type == Protocol) {
    p->instantiateprotl = noop;
    p->init = scr_init;
    p->close = noop;
    p->push = noop;
    p->pop = noop;
    p->control = scr_controlprotl;
  } else {
    p->push = scr_push;
    p->pop = noop;
    p->instantiateprotl = noop;
    p->init = noop;
    p->close = scr_close;
    p->control = scr_controlSessn;
  }
  p->open = (Pfi) scr_open;
  p->openenable = noop;
  p->opendone = noop;
  p->closedone = noop;
  p->opendisable = noop;
  p->demux = noop;
  p->getproc = scr_getproc;
}

expand_tabs(ibuf, obuf)
char *ibuf, *obuf;
{
  char c;
  int i, j;

  for (i = 0; (c = *ibuf++) != '\0';) {
    switch (c) {
    case '\t':
      for (j = ((i >> 3) + 1) * 8; i < j; i++) 
	*obuf++ = ' ';
      break;
    case '\n':
      *obuf++ = c;
      i = 0;
      break;
    default:
      *obuf++ = c;
      i++;
      break;
    }
  }
  *obuf = '\0';
}  
