h40670
s 00048/00082/00180
d D 1.2 91/01/10 10:52:33 llp 2 1
c Prepared for 3.1 Distribution
e
s 00262/00000/00000
d D 1.1 90/11/30 13:53:03 menze 1 0
c date and time created 90/11/30 13:53:03 by menze
e
u
U
f e 0
t
T
I 1
D 2
/*
E 2
I 2
/* 
E 2
 * intelEthRcv.c
 *
D 2
 * Mark Abbott, Spring 89
E 2
I 2
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
 */

D 2

#include "upi.h"
#include "process.h"
#include "debug.h"
#include "assert.h"
#include "xType.h"
E 2
I 2
#include "xkernel.h"
E 2
#include "eth.h"
#include "intelEthType.h"
#include "intelEthRcv.h"
#include "intelEthCmd.h"
#include "intelEth.h"


D 2



E 2
/*
 * function declarations
 */

extern int eth_demux();
D 2

E 2
extern void extractMsgFromFrame();


D 2




E 2
/*
 * static variables
 */

rcvFrameDesc_t *RcvFrameDescHeadPtr;
rcvFrameDesc_t *RcvFrameDescTailPtr;


D 2





E 2
/*
 * initRcv
 */
I 2

E 2
initRcv()
{
D 2

E 2
I 2
  
E 2
  TRACE0(ie, 5, "initRcv");
D 2

E 2
I 2
  
E 2
  initRcvFrameArea();
D 2

E 2
I 2
  
E 2
  SCB.rcvUnitCtlCmd = RU_START;
  ALERT_IE_DEV();
D 2

E 2
I 2
  
E 2
}				/* end initRcv */


D 2






E 2
/*
 * initRcvFrameArea
 *
 * We allocate receive buffers that are as big as the maximum ether data size.
 * Hence, we need allocate only as many Receive Buffer Descriptors as
 * Receive Frame Descriptors (each buffer will hold an entire frame).
 * The Receive Frame Descriptors are linked in a circle,
 * and the Receive Buffer Descriptors are linked in a parallel circle.
 * Although the circle of Buf Descs is pointed to only by
 * the first Frame Desc, as frames are received, each Buf Desc
 * will be used by the corresponding Frame Desc.
 */
I 2

E 2
initRcvFrameArea()
{
  unsigned rfdIx;		/* rcv frame desc index */
  unsigned rbdIx;		/* rcv buf desc index */
D 2
  MSG msg;
E 2
I 2
  Msg msg;
E 2
  char *buffer;
D 2

E 2
I 2
  
E 2
  /*
   * Build the list of receive frame descriptors
   */
D 2

E 2
I 2
  
E 2
  for (rfdIx = 0; rfdIx < NUM_RFDS; rfdIx++) {
    RcvFrameDescArray[rfdIx].lastAvailRfd = FALSE;
    RcvFrameDescArray[rfdIx].nextRfdOffset =
      IE_OFFSET_FROM_AD(&RcvFrameDescArray[(rfdIx + 1) % NUM_RFDS]);
    RcvFrameDescArray[rfdIx].rbdHeadOffset = NULL_IE_OFFSET;
    RcvFrameDescArray[rfdIx].suspendWhenDone = FALSE;
    RcvFrameDescArray[rfdIx].used = FALSE;
  }
D 2

E 2
I 2
  
E 2
  RcvFrameDescHeadPtr = &RcvFrameDescArray[0];
  RcvFrameDescTailPtr = &RcvFrameDescArray[NUM_RFDS - 1];
  RcvFrameDescTailPtr->lastAvailRfd = TRUE;
D 2

E 2
I 2
  
E 2
  /* the sysControlBlk has a ptr to the whole list of rcvFrameDescs */
  SCB.rcvFrameDescHeadOffset = IE_OFFSET_FROM_AD(RcvFrameDescHeadPtr);
D 2



E 2
I 2
  
  
  
E 2
  /*
   * Build the list of receive buffer descriptors, and the messages/buffers
   * they describe
   */
D 2

E 2
I 2
  
E 2
  for (rbdIx = 0; rbdIx < NUM_RBDS; rbdIx++) {
    RcvBufDescArray[rbdIx].nextRbdOffset =
      IE_OFFSET_FROM_AD(&RcvBufDescArray[(rbdIx + 1) % NUM_RBDS]);
D 2
    /* make the rbd point to the buffer of a MSG */
E 2
I 2
    /* make the rbd point to the buffer of a Msg */
E 2
    msg_make_allstack(msg, MAX_ETH_DATA_SZ, (char *) 0, 0);
    buffer = msg.stack->stack;
    assert(msg.stack->ref.ref > 0);
    RcvBufDescArray[rbdIx].bufPtr = IE_AD_FROM_AD(buffer);
    RcvBufDescArray[rbdIx].msg = msg;
    RcvBufDescArray[rbdIx].bufSzLoByte = LO_BYTE_OF_2(MAX_ETH_DATA_SZ);
    RcvBufDescArray[rbdIx].bufSzHiByte = HI_BYTE_OF_2(MAX_ETH_DATA_SZ);
    /* there is no lastAvailRbd, because RFDs will run out first! */
    RcvBufDescArray[rbdIx].lastAvailRbd = FALSE;
    RcvBufDescArray[rbdIx].used = FALSE;
    RcvBufDescArray[rbdIx].lastBufOfFrame = FALSE;
  }
D 2

E 2
I 2
  
E 2
  /* the head rcvFrameDesc has a ptr to the whole list of rcvBufDescs */
  RcvFrameDescHeadPtr->rbdHeadOffset = IE_OFFSET_FROM_AD(&RcvBufDescArray[0]);
D 2

E 2
I 2
  
E 2
}				/* end initRcvFrameArea */


D 2





E 2
/*
 * freeRcvBufs
 */
I 2

E 2
freeRcvBufs()
{
  unsigned rbdIx;
D 2


E 2
I 2
  
  
E 2
  for (rbdIx = 0; rbdIx < NUM_RBDS; rbdIx++) {
    msg_free(RcvBufDescArray[rbdIx].msg);
  }
D 2

E 2
I 2
  
E 2
}				/* end freeRcvBufs */


D 2






E 2
/*
 * handleRcvdFrame
 */
I 2

E 2
handleRcvdFrame()
{
D 2

E 2
I 2
  
E 2
  /* process each used Receive Frame */
  while (RcvFrameDescHeadPtr->used) {
D 2

E 2
I 2
    
E 2
    assert(RcvFrameDescHeadPtr->rcvSuccessful);
D 2

E 2
I 2
    
E 2
    /* ack this frame reception (do we have to ack each frame?) (now?) */
    SCB.ackFrameRcvd = 1;
    ALERT_IE_DEV();
D 2

E 2
I 2
    
E 2
    extractMsgFromFrame(RcvFrameDescHeadPtr);
D 2

E 2
I 2
    
E 2
    /* former head, since used and now available again, becomes tail */
    RcvFrameDescHeadPtr->used = FALSE;
    RcvFrameDescHeadPtr->lastAvailRfd = TRUE;	/* prepare to become tail */
    RcvFrameDescTailPtr->lastAvailRfd = FALSE;	/* no longer true tail */
    RcvFrameDescTailPtr = RcvFrameDescHeadPtr;
    RcvFrameDescHeadPtr = (rcvFrameDesc_t *)
      AD_FROM_IE_OFFSET(RcvFrameDescHeadPtr->nextRfdOffset);
  }
D 2

E 2
I 2
  
E 2
}				/* end handleRcvdFrame */


D 2






E 2
/*
 * extractMsgFromFrame
 */
I 2

E 2
void extractMsgFromFrame(rcvFrameDescPtr)
D 2
    rcvFrameDesc_t *rcvFrameDescPtr;
E 2
I 2
     rcvFrameDesc_t *rcvFrameDescPtr;
E 2
{
  rcvBufDesc_t *rcvBufDescPtr;
  ETHhost srcEthAd, destEthAd;
  ethType_t ethPktType;
  unsigned ethDataSz;
D 2
  MSG newMsg;
  MSG rcvdMsg;
E 2
I 2
  Msg newMsg;
  Msg rcvdMsg;
E 2
  char *buffer;
D 2

E 2
I 2
  
E 2
  /*
   * Extract info from the frame descriptor.
   */
  rcvBufDescPtr = (rcvBufDesc_t *)
    AD_FROM_IE_OFFSET(rcvFrameDescPtr->rbdHeadOffset);
  assert(rcvBufDescPtr->used);
D 2
    assert(rcvBufDescPtr->lastBufOfFrame);
    srcEthAd = rcvFrameDescPtr->srcEthAd;
E 2
I 2
  assert(rcvBufDescPtr->lastBufOfFrame);
  srcEthAd = rcvFrameDescPtr->srcEthAd;
E 2
  destEthAd = rcvFrameDescPtr->destEthAd;
  ethPktType = rcvFrameDescPtr->ethPktType;
  TRACE4(ie, 4, "extractMsgFromFrame: Packet from %x%x%x type %x",
	 srcEthAd.high, srcEthAd.mid, srcEthAd.low, ethPktType);
  rcvdMsg = rcvBufDescPtr->msg;
  assert(rcvdMsg.stack->ref.ref > 0);
  assert(rcvdMsg.stack->stack ==
	 (char *) AD_FROM_IE_AD(rcvBufDescPtr->bufPtr));
  ethDataSz = (unsigned) CAT_BYTES(rcvBufDescPtr->byteCntHiByte,
				   rcvBufDescPtr->byteCntLoByte);
D 2


E 2
I 2
  
  
E 2
  /*
   * Recycle the frame descriptor and buffer descriptor, but with a new
   * buffer (in the belly of a new msg).
   */
  msg_make_allstack(newMsg, MAX_ETH_DATA_SZ, (char *) 0, 0);
  buffer = newMsg.stack->stack;
  assert(newMsg.stack->ref.ref > 0);
  rcvBufDescPtr->msg = newMsg;
  rcvBufDescPtr->bufPtr = IE_AD_FROM_AD(buffer);
  rcvBufDescPtr->used = FALSE;
D 2


E 2
I 2
  
  
E 2
  /*
D 2
   * Arrange the passing-up of the MSG with padding removed.
E 2
I 2
   * Arrange the passing-up of the Msg with padding removed.
E 2
   */
  assert(rcvdMsg.stack->ref.ref > 0);
  rcvdMsg.stack->base = rcvdMsg.stack->stack + ethDataSz - 1;
  rcvdMsg.stack->size = ethDataSz;
  msg_push(rcvdMsg, (int) ethDataSz);
  assert(rcvdMsg.stack->ref.ref > 0);
  if (CreateKernelProcess(eth_demux, 5,
D 2
	     (sizeof rcvdMsg + 3) / 4 + 1 + 2 * ((sizeof srcEthAd + 3) / 4),
E 2
I 2
			  (sizeof rcvdMsg + 3) / 4 + 1 + 2 * ((sizeof srcEthAd + 3) / 4),
E 2
			  rcvdMsg, ethPktType, srcEthAd, destEthAd) == 0) {
    msg_free(rcvdMsg);
  }
  return;
D 2

E 2
I 2
  
E 2
}				/* end extractMsgFromFrame */
E 1
