/*
 * dirent.h
 *
 * emulation of
 *
 *   - closedir()
 *   - opendir()
 *   - readdir()
 *
 * (c) 1996 by Dirk Ohme
 */

/*---| double load prevention |----------------------------------------------*/
#ifndef __H_DIRENT
#define __H_DIRENT

/*---| definitions |---------------------------------------------------------*/
#ifndef MAXNAMLEN
#  define       MAXNAMLEN       255
#endif
#ifndef off_t
#  define       off_t           int
#endif

/*---| structures |----------------------------------------------------------*/
struct dirent {                                 /* directory entry           */
        off_t            d_off;                 /*   - offset to next entry  */
        unsigned long    d_ino;                 /*   - i-node number         */
        unsigned long    d_fileno;              /*   - file number of entry  */
        unsigned short   d_reclen;              /*   - length of record      */
        unsigned short   d_namlen;              /*   - length of d_name      */
        char             d_name[MAXNAMLEN + 1]; /*   - dir/file name         */
};                                              /*---------------------------*/
                                                /* search structure          */
#define DIR              void *
                                                /*---------------------------*/

/*---| prototypes |----------------------------------------------------------*/
int              closedir       ( DIR   *pDir
                                );
DIR             *opendir        ( char  *pszPath
                                );
struct dirent   *readdir        ( DIR   *pDir
                                );

/*---| double load prevention |----------------------------------------------*/
#endif

/*===| end of file |=========================================================*/
