@echo off
echo.
echo autoconf is detecting your system ...
echo.

set OS=
set COMPILER=
set MAKEFILE=
set MAKE=
set DBENV=
set ODBC=
set LINKAGE=STATIC

rem *** checking for OS/2 ***
:chk_0
set OS=OS/2
ver | find "Operating System/2" > Makefile.tmp
if errorlevel 1 goto chk_1
set OS=OS2
set COMPILER=GCC
set MAKEFILE=Makefile.OS2
set MAKE=make
set DBENV=unknown

rem   *** checking for iODBC environment ***
if not exist iODBC-* goto chk_0a
set ODBC=iODBC

:chk_0a
rem   *** checking for mSQL environment ***
if not exist ..\lib\mSQL.lib goto chk_0b
set DBENV=mSQL
set LINKAGE=STATIC
if not exist ..\lib\mSQL_dll.lib goto chk_0z
set LINKAGE=DYNAMIC
goto chk_0z

:chk_0b
rem   *** checking for DB2/2 environment ***
rem ==> do nothing!

echo   can't detect database environment
goto end_conf

:chk_0z
rem   *** checking for Borland C++ ***
bcc . 2>&1 | find "Borland" > Makefile.tmp
if errorlevel 1 goto chk_0y
set COMPILER=BCPP
set MAKE=make

:chk_0y
rem   *** checking for IBM C/C++ Set/2 ***
icc . 2>&1 | find "IBM" > Makefile.tmp
if errorlevel 1 goto chk_0x
set COMPILER=IBMC
set MAKE=nmake

rem   *** checking for IBM VisualAge C++ ***
icc . 2>&1 | find "VisualAge" > Makefile.tmp
if errorlevel 1 goto chk_end
set COMPILER=VACPP

:chk_0x
goto chk_end

rem *** checking for WinNT ***
:chk_1
set OS=WINNT
ver | find "NT" > Makefile.tmp
if errorlevel 1 goto chk_2
set OS=WinNT
set COMPILER=GCC
set MAKEFILE=Makefile.NT
set MAKE=make
set DBENV=mSQL
goto chk_end

rem *** unknown operating system ***
:chk_2
echo   can't detect operating system
goto end_conf

rem *** display summary ***
:chk_end
echo   operating sytem:      %OS%
echo   compiler environment: %COMPILER%
echo   original Makefile:    %MAKEFILE%
echo   'make' utility:       %MAKE%
echo   database environment: %DBENV%
echo   ODBC driver package:  %ODBC%
echo   linkage:              %LINKAGE%
echo.

rem creating files
echo   creating Config.mk ...
echo # Config.mk > Config.mk
echo # >> Config.mk
echo # (c) 1996 by Dirk Ohme, all rights reserved >> Config.mk
echo #             Dirk.Ohme@transtec.de >> Config.mk
echo. >> Config.mk
echo #-------------------- >> Config.mk
echo # operating system    >> Config.mk
echo #-------------------- >> Config.mk
echo OS=%OS% >> Config.mk

echo. >> Config.mk
echo #-------------------- >> Config.mk
echo # compiler            >> Config.mk
echo #-------------------- >> Config.mk
echo %COMPILER%=Y >> Config.mk

echo. >> Config.mk
echo #-------------------- >> Config.mk
echo # database            >> Config.mk
echo #-------------------- >> Config.mk
echo DBENV=%DBENV% >> Config.mk
echo %DBENV%=Y >> Config.mk

echo. >> Config.mk
echo #-------------------- >> Config.mk
echo # ODBC package        >> Config.mk
echo #-------------------- >> Config.mk
echo ODBC=%ODBC% >> Config.mk
if not "%ODBC%" == "" echo %ODBC%=Y >> Config.mk

echo. >> Config.mk
echo #-------------------- >> Config.mk
echo # linkage type        >> Config.mk
echo #-------------------- >> Config.mk
echo #%LINKAGE%=Y >> Config.mk

echo. >> Config.mk

echo   creating Makefiles ...
for %%a in (CLI DOC iODBC-2.12 SAMPLES) do type %%a\%MAKEFILE% > %%a\Makefile
for %%a in (CLI DOC iODBC-2.12 SAMPLES) do echo    * %%a\Makefile
if exist Makefile del Makefile
copy %MAKEFILE% Makefile

rem *** remove temporary stuff ***
:end_conf
if exist Makefile.tmp del Makefile.tmp
set LINKAGE=
set ODBC=
set DBENV=
set MAKE=
set MAKEFILE=
set COMPILER=
set OS=
echo.
echo done.

