/*
** TRANSACT.C - This is the module containing the code for ODBC for
** processing transactions.
**
** (c) 1996 by Dirk Ohme - all rights reserved
*/

#include "cli.h"

/*---------------------------------------------------------------------------*/
/*      SQLC transaction control functions.                                  */
/*---------------------------------------------------------------------------*/
RETCODE SQL_API SQLTransact(
        LPENV   lpenv,
        LPDBC   lpdbc,
        UWORD   fType)
{
        /*
        ** check parameter
        */
        LogEntry( LOG_STATUS, "[SQLTransact] lpenv = $%08lX", lpenv );
        LogEntry( LOG_STATUS, "              lpdbc = $%08lX", lpdbc );
        LogEntry( LOG_STATUS, "              fType =  %5d",   fType );
        if( (SQL_NULL_HENV == lpenv && SQL_NULL_HDBC == lpdbc)          ||
            (SQL_NULL_HDBC != lpdbc && SQL_NULL_HENV == lpdbc->pSqlEnv) )
        {
                LogEntry( LOG_ERROR,      "[SQLTransact] one handle must be specified" );
                LogEntry( LOG_RETURNCODE, "[SQLTransact] SQL_INVALID_HANDLE" );
                return SQL_INVALID_HANDLE;
        }

        /*
        ** set environment handle
        */
        if( SQL_NULL_HDBC != lpdbc )
                lpenv = lpdbc->pSqlEnv;

        /*
        ** check connections
        */
        if( (0             >= lpenv->ciConnections)              ||
            (SQL_NULL_HDBC != lpdbc && FALSE == lpdbc->fConnect) )
        {
                strcpy( lpenv->szSqlState, "08003" );
                lpenv->pszSqlMsg = "[SQLTransact] no open connections";
                LogEntry( LOG_ERROR, lpenv->pszSqlMsg );
                LogEntry( LOG_RETURNCODE,
                          "[SQLTransact] SQL_ERROR (%s)", lpenv->szSqlState );
                return SQL_ERROR;
        }

        /*
        ** check action code
        */
        if( SQL_COMMIT != fType && SQL_ROLLBACK != fType )
        {
                strcpy( lpenv->szSqlState, "S1012" );
                lpenv->pszSqlMsg = "[SQLTransact] invalid action code";
                LogEntry( LOG_ERROR, lpenv->pszSqlMsg );
                LogEntry( LOG_RETURNCODE,
                          "[SQLTransact] SQL_ERROR (%s)", lpenv->szSqlState );
                return SQL_ERROR;
        }

#ifdef mSQL
        /*
        ** fail on rollback (mSQL 1.x)
        */
        if( SQL_ROLLBACK == fType )
        {
                strcpy( lpenv->szSqlState, "58004" );
                lpenv->pszSqlMsg = "[SQLTransact] SQL_ROLLBACK failed";
                LogEntry( LOG_ERROR, lpenv->pszSqlMsg );
                LogEntry( LOG_RETURNCODE,
                          "[SQLTransact] SQL_ERROR (%s)", lpenv->szSqlState );
                return SQL_ERROR;
        }
#endif

        /*
        ** return success
        */
        LogEntry( LOG_RETURNCODE, "[SQLTransact] SQL_SUCCESS" );
        return SQL_SUCCESS;
}

/*===| end of file |=========================================================*/
