//
// Msql client library for JAVA
// Copyright (C) 1995 Darryl Collins <darryl@minmet.uq.oz.au>
// This software is provided "as is" without any expressed or implied warranty.
//
// This package implements a client for the mSQL server designed and
// implemented by David Hughes <bambi@hughes.com.au>
//
// $Log: MsqlException.java,v $
// Revision 1.1.1  1996/02/15 06:12:53  root
// Initial revision
//

// package msql;

import java.io.IOException;

/**
 * Signals that an error occurred while attempting to use a socket.
 *
 * @version	1.1.1
 * @author	Darryl Collins
 */
public class MsqlException extends IOException {

    /**
     * Constructs a new MsqlException with the specified detail 
     * message.
     * A detail message is a String that gives a specific 
     * description of this error.
     * @param msg the detail message
     */
    public MsqlException(String msg) {
	super(msg);
    }

    /**
     * Constructs a new MsqlException with no detail message.
     * A detail message is a String that gives a specific 
     * description of this error.
     */
    public MsqlException() {
    }
}

