#ifndef __ZEVENT_H
#define __ZEVENT_H

#include "zwindef.h"

class ZEventHandler;

#define EVENT_NOT_HANDLED 0xFFFFFFFE
#ifdef PLATFORM_MSWINDOWS
typedef MSG ZEventInfo;
typedef LRESULT (*ZEventProc)(ZEventInfo);
#endif

#ifdef PLATFORM_MAC
typedef EventRecord ZEventInfo;
#endif

#ifdef PLATFORM_X11
typedef XEvent ZEventInfo;
#endif

typedef unsigned int ZEvent;

class ZEventHandler	{
	public:
	ZEvent EventType;
	ZEvent EventSubType;
	ZEventProc EventProc;

	ZEventHandler(ZEventProc,ZEvent Type,ZEvent SubType);
	~ZEventHandler();

	void SetEventProc(ZEventProc);
	void SetEventType(ZEvent);
	void SetEventSubType(ZEvent);
	ZEvent GetEventType();
	ZEvent GetEventSubType();
	DWORD DoEvent(ZEventInfo);
	};

#endif


