head	1.4;
access;
symbols;
locks
	PTI:1.4; strict;
comment	@ * @;


1.4
date	96.08.04.12.00.54;	author PTI;	state Exp;
branches;
next	1.3;

1.3
date	96.08.01.23.37.22;	author PTI;	state Exp;
branches;
next	1.2;

1.2
date	96.07.24.22.12.28;	author PTI;	state Exp;
branches;
next	1.1;

1.1
date	96.07.24.20.47.42;	author PTI;	state Exp;
branches;
next	;


desc
@Structure viewer
@


1.4
log
@removed define conflict.
@
text
@/*
**      relshow.c       - Display the database structure
**
**
** Copyright (c) 1993-95  David J. Hughes
** Copyright (c) 1995  Hughes Technologies Pty Ltd
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
**
** This software is provided "as is" without any expressed or implied warranty.
**
** ID = "$Id:"
**
*/



#include <stdio.h>
#include <sys/types.h>
#ifdef WINSOCK
#  include <winsock.h>
#  undef APIENTRY
#  define APIENTRY
#else
#  include <sys/socket.h>
#  include <netinet/in.h>
#  ifdef OS2
#    include <arpa/nameser.h>
#  else
#    include <arpa/inet.h>
#  endif
#endif
#include <signal.h>
#ifndef WINSOCK
#include <netdb.h>
#endif

#include <common/portable.h>
#include "msql_prv.h"
#include "msql.h"


char    PROGNAME[] = "Relshow";

void usage()
{
        printf("\nUsage : relshow [-h host] [dbName [relName]]\n\n");
        printf("         Where   dbName is the name of a database\n");
        printf("                 relname is the name of a relation\n\n");
        printf("If no database is given, list the known databases\n");
        printf("If no relation is given, list relations in the database\n");
                  printf("If database and relation given, list fields and field types\n");
        printf("   in the given relation\n\n\007");
}




main(argc,argv)
        int     argc;
        char    *argv[];
{
        char    dbShow = 0,
                relShow = 0,
                                         fieldShow = 0;
        char    typeName[10];
        int     sock,
                argsLeft,
                errFlag = 0,
                c;
                  m_row   cur;
        m_result *res;
        m_field *curField;
        char    *host = NULL;
#ifndef UNIX
                /*
                 * OS2 & WINNT
                 */
                  int optind;

        optind    = 1;
        if( 3     < argc                  &&
            0    == strcmp(argv[1], "-h") )
        { host    = argv[2];
          optind += 2;
                  }
#else
                                         /*
                 * UNIX
                 */
        extern  int optind;
                  extern  char *optarg;


        while((c=getopt(argc,argv,"h:"))!= -1)
        {
                switch(c)
                {
                                                                case 'h':
                                if (host)
                                                                                                         errFlag++;
                                else
                                        host = optarg;
                                break;
                                                                case '?':
                                errFlag++;
                                break;
                                         }
                  }
#endif

                  /*
                  ** If we don't have a hostname have a look at MSQL_HOST
                  */
                  if (!host)
                  {
                                         host = (char *)getenv("MSQL_HOST");
                  }

                  argsLeft = argc - optind;

                  /*
                  ** Work out what we here to do
                  */

                  switch(argsLeft)
                  {
                                         case 0: dbShow++;
                                                                break;
                                         case 1: relShow++;
                                                                break;
                                         case 2: fieldShow++;
                                                                break;
                                         default:usage();
                                                                exit(1);
                  }


                  /*
                  **  Fire up mSQL
                  */

                  if ((sock = msqlConnect(host)) < 0)
                  {
#ifndef UNIX
                        /*
                         * OS2 & WINNT
                         */
                                         printf("\nError connecting to database : %s\n\n",
                       msqlGetErrMsg(NULL));
#else
                                                                /*
                         * UNIX
                         */
                printf("\nError connecting to database : %s\n\n", msqlErrMsg);
#endif
                                         exit(1);
        }

        if (!dbShow)
        {
                if(msqlSelectDB(sock,argv[optind]) < 0)
                {
#ifndef UNIX
                                                                                 /*
                                                                                  * OS2 & WINNT
                                */
                        printf("\n%s\n\n",msqlGetErrMsg(NULL));
#else
                                                                                 /*
                                * UNIX
                                                                                  */
                        printf("\n%s\n\n",msqlErrMsg);
#endif
                        msqlClose(sock);
                                                                exit(1);
                                         }
                  }


                  /*
                  ** List the available databases if required
                  */

        if (dbShow)
        {
                res = msqlListDBs(sock);
                                         if (!res)
                                         {
                        printf("\nERROR : Couldn't get database list!\n");
                        exit(1);
                }
                printf("\n\n  +-----------------+\n");
                printf("  |    Databases    |\n");
                                         printf("  +-----------------+\n");
                                         while((cur = msqlFetchRow(res)))
                {
                        printf("  | %-15.15s |\n", cur[0]);
                }
                printf("  +-----------------+\n\n");
                                         msqlFreeResult(res);
                                         msqlClose(sock);
                                         exit(0);

                  }


        /*
        ** List the available relations if required
        */

                  if (relShow)
        {

                res = msqlListTables(sock);
                                         if (!res)
                {
                        printf("\n");
                        printf("ERROR : Unable to list tables in database %s\n",
                                argv[optind]);
                        exit(1);
                }
                printf("\n\nDatabase = %s\n\n",argv[optind]);
                printf("  +---------------------+\n");
                                         printf("  |       Table         |\n");
                printf("  +---------------------+\n");
                while((cur = msqlFetchRow(res)))
                {
                                                                printf("  | %-19.19s |\n", cur[0]);
                }
                printf("  +---------------------+\n\n");
                msqlFreeResult(res);
                msqlClose(sock);
                                         exit(0);
                  }


                  /*
                  ** List the attributes and types if required
                  */

                  if (fieldShow)
        {
                /*
                ** Get the list of attributes
                */

                                         res = msqlListFields(sock,argv[optind+1]);
                if (!res)
                {
                        printf("\nERROR : Couldn't find table '%s' in '%s'\n\n",
                                argv[optind+1], argv[optind]);
                        exit(1);
                }

                /*
                ** Display the information
                */

                                         printf("\nDatabase = %s\n",argv[optind]);
                                         printf("\nTable    = %s\n\n",argv[optind + 1]);
                printf(" +-----------------+----------+--------+----------+-----+\n");
                printf(" |     Field       |   Type   | Length | Not Null | Key |\n");
                printf(" +-----------------+----------+--------+----------+-----+\n");
                while((curField = msqlFetchField(res)))
                {

                        printf(" | %-15.15s | ",curField->name);
                        switch(curField->type)
                        {
                                case INT_TYPE:
                                        strcpy(typeName,"int");
                                                                                                         break;

                                case CHAR_TYPE:
                                        strcpy(typeName,"char");
                                        break;

                                case REAL_TYPE:
                                        strcpy(typeName,"real");
                                        break;

                                default:
                                        strcpy(typeName,"Unknown");
                                        break;
                                                                }
                                                                printf("%-8.8s |",typeName);
                        printf(" %-6d |",curField->length);
                        printf(" %-8.8s |", IS_NOT_NULL(curField->flags)?
                                "Y":"N");
                        printf(" %-3.3s |\n", IS_PRI_KEY(curField->flags)?
                                "Y":"N");
                }
                printf(" +-----------------+----------+--------+----------+-----+");
                printf("\n\n");
                msqlFreeResult(res);
                msqlClose(sock);
        }
}
@


1.3
log
@Removed references to WSAStartUp and WSACleanup.
@
text
@d25 1
d55 1
a55 1
		  printf("If database and relation given, list fields and field types\n");
d68 1
a68 1
					 fieldShow = 0;
d74 1
a74 1
		  m_row   cur;
d82 1
a82 1
		  int optind;
d89 1
a89 1
		  }
d91 1
a91 1
					 /*
d95 1
a95 1
		  extern  char *optarg;
d102 1
a102 1
								case 'h':
d104 1
a104 1
													 errFlag++;
d108 1
a108 1
								case '?':
d111 2
a112 2
					 }
		  }
d115 30
a144 30
		  /*
		  ** If we don't have a hostname have a look at MSQL_HOST
		  */
		  if (!host)
		  {
					 host = (char *)getenv("MSQL_HOST");
		  }

		  argsLeft = argc - optind;

		  /*
		  ** Work out what we here to do
		  */

		  switch(argsLeft)
		  {
					 case 0: dbShow++;
								break;
					 case 1: relShow++;
								break;
					 case 2: fieldShow++;
								break;
					 default:usage();
								exit(1);
		  }


		  /*
		  **  Fire up mSQL
		  */
d146 2
a147 2
		  if ((sock = msqlConnect(host)) < 0)
		  {
d152 1
a152 1
					 printf("\nError connecting to database : %s\n\n",
d155 1
a155 1
								/*
d160 1
a160 1
					 exit(1);
d168 2
a169 2
										 /*
										  * OS2 & WINNT
d173 1
a173 1
										 /*
d175 1
a175 1
										  */
d179 3
a181 3
								exit(1);
					 }
		  }
d184 3
a186 3
		  /*
		  ** List the available databases if required
		  */
d191 2
a192 2
					 if (!res)
					 {
d198 2
a199 2
					 printf("  +-----------------+\n");
					 while((cur = msqlFetchRow(res)))
d204 3
a206 3
					 msqlFreeResult(res);
					 msqlClose(sock);
					 exit(0);
d208 1
a208 1
		  }
d215 1
a215 1
		  if (relShow)
d219 1
a219 1
					 if (!res)
d228 1
a228 1
					 printf("  |       Table         |\n");
d232 1
a232 1
								printf("  | %-19.19s |\n", cur[0]);
d237 2
a238 2
					 exit(0);
		  }
d241 3
a243 3
		  /*
		  ** List the attributes and types if required
		  */
d245 1
a245 1
		  if (fieldShow)
d251 1
a251 1
					 res = msqlListFields(sock,argv[optind+1]);
d263 2
a264 2
					 printf("\nDatabase = %s\n",argv[optind]);
					 printf("\nTable    = %s\n\n",argv[optind + 1]);
d276 1
a276 1
													 break;
d289 2
a290 2
								}
								printf("%-8.8s |",typeName);
@


1.2
log
@Ported to use winsock.h
@
text
@a76 5
#ifdef WINSOCK
		  WORD wVersionRequired = MAKEWORD(1,1);  /* winsock 1.1 required */
		  WSADATA	wsaData;
		  int nErrorStatus;
#endif
a140 8
#ifdef WINSOCK
		  if (WSAStartup(wVersionRequired, &wsaData) != 0)
		  {
			 printf("Error : Unable to initialise WINSOCK\n");
			 exit(1);
		  }
#endif

a158 3
#ifdef WINSOCK
					 WSACleanup();
#endif
a177 3
#ifdef WINSOCK
								WSACleanup();
#endif
a204 3
#ifdef WINSOCK
					 WSACleanup();
#endif
a235 3
#ifdef WINSOCK
					 WSACleanup();
#endif
a300 3
#ifdef WINSOCK
		 WSACleanup();
#endif
@


1.1
log
@Initial revision
@
text
@d23 3
a25 4
#include <sys/socket.h>
#include <netinet/in.h>
#ifdef OS2
#  include <arpa/nameser.h>
d27 7
a33 1
#  include <arpa/inet.h>
d36 1
d38 1
d54 1
a54 1
        printf("If database and relation given, list fields and field types\n");
d67 1
a67 1
                fieldShow = 0;
d73 1
a73 1
        m_row   cur;
d77 5
d86 1
a86 1
        int optind;
d93 1
a93 1
        }
d95 1
a95 1
                /*
d99 1
a99 1
        extern  char *optarg;
d106 1
a106 1
                        case 'h':
d108 1
a108 1
                                        errFlag++;
d112 1
a112 1
                        case '?':
d115 2
a116 2
                }
        }
d119 34
a152 9
        /*
        ** If we don't have a hostname have a look at MSQL_HOST
        */
        if (!host)
        {
                host = (char *)getenv("MSQL_HOST");
        }

        argsLeft = argc - optind;
d154 3
a156 15
        /*
        ** Work out what we here to do
        */

        switch(argsLeft)
        {
                case 0: dbShow++;
                        break;
                case 1: relShow++;
                        break;
                case 2: fieldShow++;
                        break;
                default:usage();
                        exit(1);
        }
d158 2
a159 7

        /*
        **  Fire up mSQL
        */

        if ((sock = msqlConnect(host)) < 0)
        {
d164 1
a164 1
                printf("\nError connecting to database : %s\n\n",
d167 1
a167 1
                        /*
d172 4
a175 1
                exit(1);
d183 2
a184 2
                               /*
                                * OS2 & WINNT
d188 1
a188 1
                               /*
d190 1
a190 1
                                */
d194 6
a199 3
                        exit(1);
                }
        }
d202 3
a204 3
        /*
        ** List the available databases if required
        */
d209 2
a210 2
                if (!res)
                {
d216 2
a217 2
                printf("  +-----------------+\n");
                while((cur = msqlFetchRow(res)))
d222 6
a227 3
                msqlFreeResult(res);
                msqlClose(sock);
                exit(0);
d229 1
a229 1
        }
d236 1
a236 1
        if (relShow)
d240 1
a240 1
                if (!res)
d249 1
a249 1
                printf("  |       Table         |\n");
d253 1
a253 1
                        printf("  | %-19.19s |\n", cur[0]);
d258 5
a262 2
                exit(0);
        }
d265 3
a267 3
        /*
        ** List the attributes and types if required
        */
d269 1
a269 1
        if (fieldShow)
d275 1
a275 1
                res = msqlListFields(sock,argv[optind+1]);
d287 2
a288 2
                printf("\nDatabase = %s\n",argv[optind]);
                printf("\nTable    = %s\n\n",argv[optind + 1]);
d300 1
a300 1
                                        break;
d313 2
a314 2
                        }
                        printf("%-8.8s |",typeName);
d326 3
@
