/*************************************************************************/
/*                                                                       */
/* ITSC Redbook OS/2 v2.0 Sample Program                                 */
/*                                                                       */
/*                                                                       */
/* PWFOLDER.C                                                            */
/*                                                                       */
/*                                                                       */
/*************************************************************************/

/*
 * This file was generated by the SOM Compiler.
 * FileName: pwfolder.c.
 * Generated using:
 *     SOM Precompiler spc: 1.22
 *     SOM Emitter emitc: 1.24
 */
#define INCL_WIN
#define INCL_DOS
#define INCL_GPIBITMAPS
#define INCL_WPCLASS
#define INCL_WPFOLDER

/******************************************************************************/
/* System-defined header files                                                */
/******************************************************************************/
#include <os2.h>

#include <pmwp.h>  /* eventually will be #define INCL_WINWORKPLACE */

#include <string.h>
#include <stdio.h>
#include <memory.h>
#include <stdlib.h>

/******************************************************************************/
/* Function prototype for dialog proc                                         */
/******************************************************************************/
MRESULT EXPENTRY PasswordDlgProc(HWND hwndDlg,
                                 ULONG msg,
                                 MPARAM mp1,
                                 MPARAM mp2);

/******************************************************************************/
/* Dialog definitions header file                                             */
/******************************************************************************/
#include "dialog.h"

/******************************************************************************/
/* Global data                                                                */
/******************************************************************************/
HMODULE  hmodThisClass;                          /* Module handle             */
HPOINTER hLockedIcon;                            /* Handle for locked icon    */
HPOINTER hUnlockedIcon;                          /* Handle for unlocked icon  */

PSZ      DefaultClassTitle = "Password Folder";  /* Default folder title      */


#define PWFolder_Class_Source
#include "pwfolder.ih"

/*
 *
 *   METHOD:   QueryInfo                                   PRIVATE
 *
 *   PURPOSE:  Copies instance data into the PWF_INFO structure.
 *
 *   INVOKED:  From PasswordDlgProc
 *
 */

SOM_Scope BOOL   SOMLINK pwfolder_QueryInfo(PWFolder *somSelf,
                PPWF_INFO pPWFolderInfo)
{
    PWFolderData *somThis =                      /* Get instance data pointer */
           PWFolderGetData(somSelf);
    PWFolderMethodDebug("PWFolder",              /* Set debug info            */
          "pwfolder_QueryInfo");

    strcpy(pPWFolderInfo->szCurrentPassword,     /* Set user-entered password */
           _szCurrentPassword);
    strcpy(pPWFolderInfo->szPassword,            /* Set folder password       */
           _szPassword);
    strcpy(pPWFolderInfo->szUserid,              /* Set userid                */
           _szUserid);

    return (BOOL) 0;                             /* Return                    */
}

/*
 *
 *   METHOD:   SetInfo                                     PRIVATE
 *
 *   PURPOSE:  Sets instance data from the PWF_INFO structure.
 *
 *   INVOKED:  From PasswordDlgProc
 *
 */

SOM_Scope BOOL   SOMLINK pwfolder_SetInfo(PWFolder *somSelf,
                PPWF_INFO pPWFolderInfo)
{
    PWFolderData *somThis =                      /* Get instance data pointer */
           PWFolderGetData(somSelf);
    PWFolderMethodDebug("PWFolder",              /* Set debug info            */
          "pwfolder_QueryInfo");

    strcpy(_szCurrentPassword,                   /* Save user-entered p'word  */
           pPWFolderInfo->szCurrentPassword);
    strcpy(_szPassword,                          /* Save folder password      */
           pPWFolderInfo->szPassword);
    strcpy(_szUserid,                            /* Save userid               */
           pPWFolderInfo->szUserid);

    return (BOOL) 0;                             /* Return                    */
}

/*
 *
 *   METHOD:   LockFolder                                  PUBLIC
 *
 *   PURPOSE:  Invalidates the current password, thereby locking the folder.
 *
 *   INVOKED:  From _wpMenuItemSelected
 *
 */

SOM_Scope BOOL   SOMLINK pwfolder_LockFolder(PWFolder *somSelf)
{
    BOOL bSuccess;

    PWFolderData *somThis =                      /* Get instance data pointer */
           PWFolderGetData(somSelf);
    PWFolderMethodDebug("PWFolder",              /* Set debug info            */
          "pwfolder_QueryInfo");

    strcpy(_szCurrentPassword,"NOPASSWD");       /* Invalid user-entered      */
                                                 /* password                  */
    _wpSetTitle(somSelf,                         /* Set folder title to       */
                _wpQueryTitle(somSelf) );        /* locked state              */

    bSuccess=_wpSetIcon(somSelf,                 /* Set icon to locked state  */
                        hLockedIcon);

    _wpSaveImmediate(somSelf);                   /* Rember this state         */
    return (BOOL) 0;                             /* Return                    */
}

/*
 *
 *   METHOD:   wpInitData                                  PUBLIC
 *
 *   PURPOSE:  Initializes instance data
 *
 *   INVOKED:  By Workplace Shell, upon instantiation of the object instance.
 *
 */

SOM_Scope void   SOMLINK pwfolder_wpInitData(PWFolder *somSelf)
{
    CHAR  ErrorBuffer[100];

    PWFolderData *somThis =                      /* Get instance data pointer */
                 PWFolderGetData(somSelf);
    PWFolderMethodDebug("PWFolder",              /* Set debug info            */
                        "pwfolder_wpInitData");

    parent_wpInitData(somSelf);                  /* Invoke default processing */

    strcpy(_szCurrentPassword,"password");       /* Initialise folder in the  */
    strcpy(_szPassword,"password");              /* unlocked state            */
}

/*
 *
 *   METHOD:   wpModifyPopupMenu                           PUBLIC
 *
 *   PURPOSE:  Adds an additional "Lock" item to the object's context menu.
 *
 *   INVOKED:  By Workplace Shell, upon instantiation of the object instance.
 *
 */

SOM_Scope BOOL   SOMLINK pwfolder_wpModifyPopupMenu(PWFolder *somSelf,
                HWND hwndMenu,
                HWND hwndCnr,
                ULONG iPosition)
{
    PWFolderData *somThis =                      /* Get instance data pointer */
                 PWFolderGetData(somSelf);
    PWFolderMethodDebug("PWFolder",              /* Set debug info            */
                        "pwfolder_wpModifyPopupMenu");

    _wpInsertPopupMenuItems(somSelf,             /* Insert menu item          */
                            hwndMenu,            /* Menu handle               */
                            iPosition,           /* Default position          */
                            hmodThisClass,       /* Module handle             */
                            ID_CXTMENU_LOCK,     /* Menu item identifier      */
                            0);                  /* No submenu identifier     */

    return(parent_wpModifyPopupMenu(somSelf,     /* Invoke default processing */
                                    hwndMenu,
                                    hwndCnr,
                                    iPosition));
}

/*
 *
 *   METHOD:   wpMenuItemSelected                          PUBLIC
 *
 *   PURPOSE:  Processes the user's selections from the context menu.  The
 *             overridden method processes only the added "Lock" item, before
 *             invoking the parent's default processing to handle other items.
 *
 *   INVOKED:  By Workplace Shell, upon selection of a menu item by the user.
 *
 */

SOM_Scope BOOL   SOMLINK pwfolder_wpMenuItemSelected(PWFolder *somSelf,
                HWND hwndFrame,
                ULONG ulMenuId)
{
    PWFolderData *somThis =                      /* Get instance data pointer */
                 PWFolderGetData(somSelf);
    PWFolderMethodDebug("PWFolder",              /* Set debug info            */
                        "pwfolder_wpMenuItemSelected");

    switch( ulMenuId )                           /* Switch on item identifier */
    {
       case IDM_LOCK:                            /* Lock item selected        */
          _LockFolder(somSelf);                  /* Invoke _LockFolder method */
          break;

       default:                                  /* All other items           */
          parent_wpMenuItemSelected(somSelf,     /* Invoke default processing */
                                    hwndFrame,
                                    ulMenuId);
          break;
    }
}

/*
 *
 *   METHOD:   wpOpen                                      PUBLIC
 *
 *   PURPOSE:  Only allows a folder to be opened if the folder is unlocked, or
 *             if the user supplies the correct password in response to the
 *             dialog.
 *
 *   INVOKED:  By Workplace Shell, upon selection of the "Open" menu item by
 *             the user.
 *
 */

SOM_Scope HWND   SOMLINK pwfolder_wpOpen(PWFolder *somSelf,
                HWND hwndCnr,
                ULONG ulView,
                ULONG param)
{
    ULONG    ulResult;                           /* Return value              */
    CHAR     szTitle[100];                       /* Folder title buffer       */
    PVOID    pCreateParam;

    PWFolderData *somThis =                      /* Get instance data pointer */
                 PWFolderGetData(somSelf);
    PWFolderMethodDebug("PWFolder",              /* Set debug info            */
                        "pwfolder_wpOpen");

    if ((strcmp(_szCurrentPassword,              /* If folder is not locked   */
         _szPassword)) == 0)
    {
        return(parent_wpOpen(somSelf,            /* Allow open to proceed in  */
                             hwndCnr,            /* normal way using default  */
                             ulView,             /* processing                */
                             param));
    }
    pCreateParam = malloc( sizeof(ULONG) );      /* Allocate memory to pass a */
                                                 /* ULONG to the dialog proc  */
    *((PULONG)pCreateParam) = (ULONG)somSelf;    /* Put the somSelf pointer   */
                                                 /* in the CreateParam memory */

    ulResult = WinDlgBox(HWND_DESKTOP,           /* Display password dialog   */
                         HWND_DESKTOP,           /* Desktop is owner          */
                         PasswordDlgProc,        /* Dialog procedure address  */
                         hmodThisClass,          /* Module handle             */
                         ID_DLG_PASSWORD,        /* Dialog resource id        */
                         pCreateParam );         /* Create Param holding the  */
                                                 /* pointer to this object    */

    if (ulResult == DID_OK )                     /* If user hit OK button     */
       {
       if ((strcmp(_szCurrentPassword,           /* If password is correct    */
                   _szPassword)) == 0)
          {
          strcpy(szTitle,                        /* Get title string          */
                 _wpQueryTitle(somSelf));
          szTitle[strlen(szTitle)-9] = '\0';     /* Remove <LOCKED>           */
          _wpSetTitle(somSelf,szTitle);          /* Reset title string        */

          _wpSetIcon(somSelf,                    /* Set icon to unlocked      */
                     hUnlockedIcon);             /* state                     */

          return(parent_wpOpen(somSelf,          /* Allow open to proceed in  */
                               hwndCnr,          /* normal way using default  */
                               ulView,           /* processing                */
                               param));
          }
       else                                      /* Password is incorrect     */
          {
          WinMessageBox(HWND_DESKTOP,            /* Display message to user   */
                        HWND_DESKTOP,
                        "Password incorrect. Folder remains locked.",
                        "Password Failed",
                        0,
                        MB_OK |
                        MB_CUAWARNING );
          return((HWND)0);                       /* Return NULL handle        */
          }
       }
}

/*
 *
 *   METHOD:   wpSetTitle                                  PUBLIC
 *
 *   PURPOSE:  Sets the folder's title (icon text) to have the phrase <Locked>
 *             as a suffix if the folder is locked, or removes this suffix if
 *             the folder is unlocked.
 *
 *   INVOKED:  By wpOpen to set the unlocked state, and by LockFolder to set
 *             the locked state.
 *
 */

SOM_Scope BOOL   SOMLINK pwfolder_wpSetTitle(PWFolder *somSelf,
                PSZ pszNewTitle)
{
    CHAR szBuf[100];                             /* Character buffer          */

    PWFolderData *somThis =                      /* Get instance data pointer */
                 PWFolderGetData(somSelf);
    PWFolderMethodDebug("PWFolder",              /* Set debug info            */
                        "pwfolder_wpSetTitle");

    strcpy(szBuf,pszNewTitle);                   /* Get current title         */

    if ((strcmp(_szCurrentPassword,              /* If folder is locked       */
                _szPassword)) != 0)
    {
       if ((strstr(szBuf,"LOCKED")) == NULL)     /* and <LOCKED> not in       */
       {                                         /* current title             */
          strcat(szBuf," <LOCKED>");             /* Add <LOCKED> to title     */
       }
    }
    return (parent_wpSetTitle(somSelf,szBuf));   /* Invoke default processing */
}

/*
 *
 *   METHOD:   wpSetup                                     PUBLIC
 *
 *   PURPOSE:  Sets folder properties based upon a setup string passed by the
 *             object's creator as part of the WinCreateObject() call.  The
 *             overridden method simply processes the PASSWORD keyword to set
 *             the folder's password immediately upon instantiation, before
 *             invoking the parent's default processing to handle all other
 *             keywords.
 *
 *   INVOKED:  By the Workplace Shell, upon instantiation of the object
 *             instance.
 *
 */

SOM_Scope BOOL   SOMLINK pwfolder_wpSetup(PWFolder *somSelf,
                PSZ pszSetupString)
{
    CHAR  pszInitPword[20];                      /* Character buffer          */
    BOOL  bFound;                                /* Success flag              */
    ULONG Length;                                /* Returned length           */

    PWFolderData *somThis =                      /* Get instance data pointer */
                 PWFolderGetData(somSelf);
    PWFolderMethodDebug("PWFolder",              /* Get debug info            */
                        "pwfolder_wpSetup");

    if (*pszSetupString != '\0')                 /* If string is present      */
       {
       bFound=_wpScanSetupString(somSelf,        /* Parse setup string to     */
                                 pszSetupString, /* find PASSWORD keyword     */
                                 "PASSWORD",
                                 pszInitPword,   /* Buffer for keyword value  */
                                 &Length);       /* Length of returned string */

       if (bFound)
          {
          strcpy(_szPassword,                    /* Initialize folder         */
                 pszInitPword);                  /* password                  */
          strcpy(_szCurrentPassword,             /* Initialize user-entered   */
                 pszInitPword);                  /* password                  */
          }
       }
    return(parent_wpSetup(somSelf,               /* Invoke default processing */
                          pszSetupString));
}

/*
 *
 *   METHOD:   wpSaveState                                 PUBLIC
 *
 *   PURPOSE:  Saves the object instance's persistent state data.  The
 *             overridden method simply saves the password data, then invokes
 *             the parent's default processing to handle any other instance
 *             data defined by ancestor classes.
 *
 *   INVOKED:  By the Workplace Shell, when the object becomes dormant.
 *
 */

SOM_Scope BOOL   SOMLINK pwfolder_wpSaveState(PWFolder *somSelf)
{
    PWFolderData *somThis =                      /* Get instance data pointer */
                 PWFolderGetData(somSelf);
    PWFolderMethodDebug("PWFolder",              /* Set debug info            */
                        "pwfolder_wpSaveState");

    _wpSaveString(somSelf,                       /* Save folder password      */
                  "PWFolder",                    /* Class name                */
                  1L,                            /* Class-defined key         */
                  _szPassword);                  /* String to be saved        */
    _wpSaveString(somSelf,                       /* Save user-entered p'word  */
                  "PWFolder",                    /* Class name                */
                  2L,                            /* Class-defined key         */
                  _szCurrentPassword);           /* String to be saved        */

    return(parent_wpSaveState(somSelf));         /* Invoke default processing */
}

/*
 *
 *   METHOD:   wpRestoreState                              PUBLIC
 *
 *   PURPOSE:  Restores the object instance's persistent state data.  The
 *             overridden method simply restores the password data, then
 *             invokes the parent's default processing to handle any other
 *             instance data defined by ancestor classes.
 *
 *   INVOKED:  By the Workplace Shell, when the object becomes awake.
 *
 */

SOM_Scope BOOL   SOMLINK pwfolder_wpRestoreState(PWFolder *somSelf,
                ULONG ulReserved)
{
    ULONG ulRetLength;                           /* Length of returned string */

    PWFolderData *somThis =                      /* Get instance data pointer */
                 PWFolderGetData(somSelf);
    PWFolderMethodDebug("PWFolder",              /* Set debug info            */
                        "pwfolder_wpRestoreState");

    _wpRestoreString(somSelf,                    /* Restore folder password   */
                     "PWFolder",                 /* Class name                */
                     1L,                         /* Class-defined key         */
                     _szPassword,                /* String to be restored     */
                     &ulRetLength);              /* Length of returned string */
    _wpRestoreString(somSelf,                    /* Restore user-entered pwd  */
                     "PWFolder",                 /* Class name                */
                     2L,                         /* Class-defined key         */
                     _szCurrentPassword,         /* String to be restored     */
                     &ulRetLength);              /* Length of returned string */

    if ((strcmp(_szCurrentPassword,              /* If folder is locked       */
                _szPassword)) != 0)
    {
       _wpSetIcon(somSelf, hLockedIcon);         /* Set icon to locked state  */
    }

    return(parent_wpRestoreState(somSelf,        /* Invoke default processing */
                                 ulReserved));
}

/*
 *
 *   METHOD:   wpSetIcon                                   PUBLIC
 *
 *   PURPOSE:  This class method returns the handle to the correct icon for
 *             the object.
 *
 *   INVOKED:
 *
 */

SOM_Scope BOOL   SOMLINK pwfolder_wpSetIcon(PWFolder *somSelf,
                HPOINTER hptrNewIcon)
{
    PWFolderData *somThis = PWFolderGetData(somSelf);
    PWFolderMethodDebug("PWFolder","pwfolder_wpSetIcon");

    if ((strcmp(_szCurrentPassword,         /* If password is correct     */
                _szPassword)) == 0)
    {
       return (parent_wpSetIcon(somSelf,
                     hUnlockedIcon));       /* return pointer to unlocked */
    }
    else                                    /* otherwise                  */
    {
       return (parent_wpSetIcon(somSelf,
                     hLockedIcon));         /* return locked icon pointer */
    }
}

#undef SOM_CurrentClass
#define SOM_CurrentClass SOMMeta
/*
 *
 *   METHOD:   wpclsQueryTitle                             PUBLIC
 *
 *   PURPOSE:  This class method returns the default folder title for any
 *             instance of the password protected folder class.  This title
 *             is used if a title is not supplied in the WinCreateObject()
 *             call.
 *
 *   INVOKED:  By the Workplace Shell, upon instantiation of the object
 *             instance.
 *
 */

SOM_Scope PSZ   SOMLINK pwfoldercls_wpclsQueryTitle(M_PWFolder *somSelf)
{
    /* M_PWFolderData *somThis = M_PWFolderGetData(somSelf); */

    M_PWFolderMethodDebug("M_PWFolder",          /* Set debug info            */
                          "pwfoldercls_wpclsQueryTitle");

    return(DefaultClassTitle);                   /* Return default title      */
}

/*
 *
 *   METHOD:   wpclsQueryIcon                              PUBLIC
 *
 *   PURPOSE:  This class method returns the handle to the default icon for
 *             the class.  This method is not used in the current version,
 *             but could be used if different icons are to be used for the
 *             locked and unlocked states.
 *
 *   INVOKED:
 *
 */

SOM_Scope HPOINTER   SOMLINK pwfoldercls_wpclsQueryIcon(M_PWFolder *somSelf)
{
    /* M_PWFolderData *somThis = M_PWFolderGetData(somSelf); */
    PWFolderData *somThis =                      /* Get instance data pointer */
                 PWFolderGetData(somSelf);

    M_PWFolderMethodDebug("M_PWFolder",          /* Set debug info            */
                          "pwfoldercls_wpclsQueryIcon");

    return(hUnlockedIcon);
}

/*
 *
 *   METHOD:   wpclsInitData                               PUBLIC
 *
 *   PURPOSE:  This class method allows the initialization of any class data
 *             items.  The overridden method simply obtains a module handle
 *             to be used when accessing Presentation Manager resources, then
 *             invokes the parent's default processing.
 *
 *   INVOKED:  By the Workplace Shell, upon loading the class DLL.
 *
 */

SOM_Scope void   SOMLINK pwfoldercls_wpclsInitData(M_PWFolder *somSelf)
{
    CHAR  ErrorBuffer[100];                      /* Error buffer              */

    /* M_PWFolderData *somThis = M_PWFolderGetData(somSelf); */

    M_PWFolderMethodDebug("M_PWFolder",          /* Set debug info            */
                          "pwfoldercls_wpclsInitData");

    DosLoadModule((PSZ) ErrorBuffer,             /* Obtain DLL module handle  */
                  sizeof(ErrorBuffer),
                  "PWFOLDER",                    /* Module name               */
                  &hmodThisClass);                       /* Module handle             */

    hLockedIcon=WinLoadPointer(HWND_DESKTOP,     /* Load icons                */
                               hmodThisClass,
                               ID_LOCK);
    hUnlockedIcon=WinLoadPointer(HWND_DESKTOP,
                                 hmodThisClass,
                                 ID_UNLOCK);

    parent_wpclsInitData(somSelf);               /* Invoke default processing */
}

/*
 *
 *   METHOD:   wpclsUnInitData                             PUBLIC
 *
 *   PURPOSE:  This class method allows the release of any class data items
 *             or resources.  The overridden method releases the module handle
 *             obtained by wpclsInitData, then invokes the parent's default
 *             processing.
 *
 *   INVOKED:  By the Workplace Shell, upon unloading the class DLL.
 *
 */

SOM_Scope void   SOMLINK pwfoldercls_wpclsUnInitData(M_PWFolder *somSelf)
{
    /* M_PWFolderData *somThis = M_PWFolderGetData(somSelf); */

    M_PWFolderMethodDebug("M_PWFolder",          /* Set debug info            */
                          "pwfoldercls_wpclsUnInitData");

    WinDestroyPointer(hLockedIcon);              /* Free icons                */
    WinDestroyPointer(hUnlockedIcon);

    DosFreeModule(hmodThisClass);                        /* Free module handle        */

    parent_wpclsUnInitData(somSelf);
}

/******************************************************************************/
/*                                                                            */
/* PROCEDURE NAME:  PasswordDlgProc                                           */
/*                                                                            */
/* description:  Dialog procedure for password dialog                         */
/*                                                                            */
/* invoked:  By Presentation Manager, in response to folder issuing           */
/*           WinDlgBox() call from _wpOpen method.                            */
/*                                                                            */
/******************************************************************************/
MRESULT EXPENTRY PasswordDlgProc(HWND hwndDlg,
                                 ULONG msg,
                                 MPARAM mp1,
                                 MPARAM mp2)
{
   PWFolder *aPWF;                               /* Define SOM pointer        */
   PWF_INFO pwfolderInfo;                        /* Define password structure */
   CHAR     szTemp[100];                         /* Character buffer          */

   switch (msg)                                  /* Determine message class   */
   {
      case WM_INITDLG:                           /* Dialog being initialized  */

         WinSetWindowULong(hwndDlg,              /* Store SOM pointer in      */
                          QWL_USER,              /* window word QWL_USER      */
                          *((PULONG)mp2));
         free(mp2);                              /* Free Create Param memory  */
         break;

      case WM_COMMAND:                           /* User hit a pushbutton     */

         aPWF = (PWFolder *)WinQueryWindowULong(hwndDlg, QWL_USER);

         _QueryInfo(aPWF,                        /* Get password data         */
                    &pwfolderInfo);

         switch (SHORT1FROMMP(mp1))              /* Which button was hit?     */
         {
            case DID_OK:                         /* Okay button               */

               WinQueryDlgItemText(hwndDlg,      /* Get text from entryfield  */
                            ID_EF_PASSWORD,
                            sizeof(szTemp),
                            (PSZ)szTemp);

                                                 /* Copy to password data     */
               strcpy(pwfolderInfo.szCurrentPassword, szTemp);

               _SetInfo(aPWF,&pwfolderInfo);     /* Set instance data         */
               WinDismissDlg(hwndDlg,DID_OK);    /* Dismiss dialog            */
               break;

            case DID_CANCEL:                     /* Cancel button hit         */

               WinDismissDlg(hwndDlg,            /* Dismiss dialog            */
                             DID_CANCEL);
               break;
         }
         return(MRESULT)TRUE;                    /* Return from WM_COMMAND    */
         break;
   }
   return(WinDefDlgProc(hwndDlg,                 /* Invoke default PM message */
                        msg,                     /* handling                  */
                        mp1,
                        mp2));
}
