
#include <stdio.h>
#include <string.h>


#include "mpatch.h"



class MyPatch : public MPatch
	{
	public:
	 void Show_start();
	 void Show();
	 void Show_end();
	};


void MyPatch::Show_start()
{
 puts("\nStart applying patch. Please Wait...");
}

void MyPatch::Show()
{
 static short i=0;
 printf("%3d",i++);
}

void MyPatch::Show_end()
{
 puts("\nOk. Finished!");
}





int main(int argc, char *argv[])
{
 MyPatch patch;

 puts("SAMPLE - A simply *.MDF applier");
 puts("(C) 1993/94 Maurizio Giunti");

 char diffile[256];
 char oldfile[256];
 char newfile[256];

 if((argc<2)||(argc>4))
	{
	 puts("Usage: SAMPLE <mdf> [<old>] [<new>]");
	 return 0;
	}

 *diffile=NULL;
 *oldfile=NULL;
 *newfile=NULL;

 for(short i=1;i<argc;i++)
	{
	 if(*diffile==NULL) strcpy(diffile,argv[i]);
	 else if(*oldfile==NULL) strcpy(oldfile,argv[i]);
	 else strcpy(newfile,argv[i]);
	}


 // Getting info from MDF file
 MDF_header_info hi;

 i=readMDFhead(diffile,&hi);
 switch(i)
	{
	 case 0:
	 puts("MDF file not found !");
	 return 0;

	 case -1:
	 puts("Not an MDF file !");
	 return 0;

	 case -2:
	 puts("Wrong MDF version !");
	 return 0;
	}
 printf("Algorithm version: %s\n",hi.alg_ver);
 printf("MDF file produced by: %s\n",hi.registeredto);
 printf("Chunk len: %d  Number of chunks: %lu\n",hi.chunk_len,hi.n_chunks);


 // Start applying patch
 patch.SetRate(3);
 if(patch.MDFPatch(diffile,oldfile,newfile)!=0)
	{
	 puts(patch.LastError());
	}
 else puts("<Done!>");
 return 0;
}




