#include "f2c.h"
#include "fio.h"
#include "sys/types.h"
#include "fcntl.h"
#include "rawio.h"
#ifndef O_RDONLY
#define O_RDONLY 0
#endif

#ifdef KR_headers
extern char *strcpy();
#else
#undef abs
#undef min
#undef max
#include "stdlib.h"
#include "string.h"
#endif
#ifdef OS2
#undef INT
#include <sys/types.h>
#include <sys/stat.h>
#define INCL_DOSFILEMGR
#include <os2.h>
#endif


#ifdef KR_headers
integer f_end(a) alist *a;
#else
integer f_end(alist *a)
#endif
{
	unit *b;
	if(a->aunit>=MXUNIT || a->aunit<0) err(a->aerr,101,"endfile");
	b = &f__units[a->aunit];
	if(b->ufd==NULL) {
		char nbuf[10];
		(void) sprintf(nbuf,"fort.%ld",a->aunit);
#ifdef OS2
		close(open(nbuf, O_TRUNC|O_CREAT|O_RDWR,S_IREAD|S_IWRITE));
#else
		close(creat(nbuf, 0666));
#endif
		return(0);
		}
	b->uend=1;
	return(b->useek ? t_runc(a) : 0);
}

 static int
#ifdef KR_headers
copy(from, len, to) char *from, *to; register long len;
#else
copy(char *from, register long len, char *to)
#endif
{
	register int n;
	int k, rc = 0, tmp;
	char buf[BUFSIZ];

	if ((k = open(from, O_RDONLY)) < 0)
		return 1;
	if ((tmp = creat(to,0666)) < 0)
		return 1;
	while((n = read(k, buf, len > BUFSIZ ? BUFSIZ : (int)len)) > 0) {
		if (write(tmp, buf, n) != n)
			{ rc = 1; break; }
		if ((len -= n) <= 0)
			break;
		}
	close(k);
	close(tmp);
	return n < 0 ? 1 : rc;
	}

#ifndef L_tmpnam
#define L_tmpnam 16
#endif

 int
#ifdef KR_headers
t_runc(a) alist *a;
#else
t_runc(alist *a)
#endif
{
	char nm[L_tmpnam];
	long loc, len;
	unit *b;
	int rc = 0;

	b = &f__units[a->aunit];
	if(b->url || b->useek==0 ) return(0);	/*don't truncate direct files*/
#ifdef OS2
        /* for formatted files, we flush buffer and use system call
         to find where the real position is, i.e. taking into account
         the CRs added by the C functions for text-mode output */
        if(b->ufmt != 0) {
            fflush( b->ufd ) ;
            DosSetFilePtr( fileno(b->ufd), 0L, 1L, &loc ) ;
            }
        else loc=ftell(b->ufd);        
#else
	loc=ftell(b->ufd);        
#endif
	(void) fseek(b->ufd,0L,SEEK_END);
	len=ftell(b->ufd);
	if (loc >= len || b->useek == 0 || b->ufnm == NULL)
		return(0);
	rewind(b->ufd);	/* empty buffer */
#ifdef OS2
        DosSetFileSize( fileno( b->ufd ), loc ) ;
        if(b->uwrt) b->uwrt=1 ;
	(void) fseek(b->ufd,0L,SEEK_END);
        return 0 ;
#else	
	if (!loc) {
		if (close(creat(b->ufnm,0666)))
			{ rc = 1; goto done; }
		if (b->uwrt)
			b->uwrt = 1;
		return 0;
		}
#ifdef _POSIX_SOURCE
	tmpnam(nm);
#else
	(void) strcpy(nm,"tmp.FXXXXXX");
	(void) mktemp(nm);
#endif
	if (copy(b->ufnm, loc, nm)
	 || copy(nm, loc, b->ufnm))
		rc = 1;
	unlink(nm);
done:
	fseek(b->ufd, loc, SEEK_SET);
	if (rc)
		err(a->aerr,111,"endfile");
	return 0;
#endif /* OS2 */
	}
