{$PAGESIZE: 58, $LINESIZE: 132, $TITLE: 'Timer Routines'}
{$INCLUDE: 'TIMI.PAS'}

{This program illustrates is an intermediate-level Pascal program,
 which illustrates how a Pascal unit can be created and how DOS calls
 can be made with Pascal using the DOSXQQ function.  This unit provides
 a procedure (ExactTime) which will get the system clock time and another
 procedure (Delay) which will wait for a specified time; this latter 
 capability was useful in developing routines for the Hayes SmartModem
 which required specific delays.}

IMPLEMENTATION OF TIM;

VAR [EXTERN] CRCXQQ, CRDXQQ: WORD;
  
FUNCTION DOSXQQ (command: BYTE; parm: WORD): CHAR; EXTERN;

PROCEDURE EXACTTIME; {(VAR hrs, mins, secs: REAL);}

{Procedure EXACTTIME provides the exact time in hours, minutes, and seconds.}
  
VAR
  a: CHAR;
  b, c: INTEGER;
  
BEGIN
  a:= DOSXQQ (44,0);
  b:= ORD (CRCXQQ);
  c:= ORD (CRDXQQ);
  hrs:= b DIV 256;
  mins:= b MOD 256;
  secs:= c DIV 256 + (c MOD 256) / 100
END;  
  
PROCEDURE DELAY; {(wsecs: REAL);}  

{Procedure DELAY will generate a delay of wsecs seconds.}

VAR
  bhrs, bmins, bsecs, ehrs, emins, esecs: REAL;

BEGIN
  EXACTTIME (bhrs, bmins, bsecs);
  esecs:= bsecs + wsecs;
  IF esecs >= 60 THEN
    BEGIN
      emins:= bmins + 1;
      IF emins >= 60 THEN 
        BEGIN
          ehrs:= bhrs + 1;
          emins:= emins - 60
        END
      ELSE ehrs:= bhrs;
      esecs:= esecs - 60
    END
  ELSE emins:= bmins;
  WHILE ehrs > bhrs DO EXACTTIME (bhrs, bmins, bsecs);
  WHILE emins > bmins DO EXACTTIME (bhrs, bmins, bsecs);
  WHILE esecs > bsecs DO EXACTTIME (bhrs, bmins, bsecs)
END;

BEGIN
END.