// bstateb.h : header file
//
// How to use CBStateButton
//
// 1. Create your dialog with an Ownerdraw pushbutton
//
// 2. Create bitmaps for each of your states (they must be the same size as
//    the pushbutton for now)
//
// 3. Declare a CBStateButton in your dialog class
//
// In your InitDialog function
//
//		1. call the CBStateButton's AttachToButton(pushbuttonID, this) member
//
//		2. call the CBStateButton's AddState() function.  The first argument
//		   is the state value.  If you use your bitmap ID numbers as state
//		   values, this is all you need.  Otherwise, the second argument
//		   should be given as the bitmap ID number
//
//		3. call the CBStateButton's SetStateNumber() function any time you want to
//		   set the button's state
//
// Other routines:
//
//	GetStateNumber() returns the current state
//
// TODO: Add a way to set a background color (default to the upper left pixel of
//       the bitmap) and make centering work
// 

/////////////////////////////////////////////////////////////////////////////
// CBStateButton window

#define _CBSTATEMAX_	20

class CBStateButton : public CButton
{
	DECLARE_DYNAMIC(CBStateButton)
	
// Construction
public:
	CBStateButton(BOOL bCenter = FALSE, UINT nID = 0, CWnd *pParent = NULL);

// Attributes
public:

// Operations
public:
	void AttachToButton(UINT, CWnd *);
	void AddState(UINT, UINT);
	void AddState(UINT);
	// void AddState(UINT, CBitmap *);
	void SetStateNumber(UINT);
	int GetStateNumber(void);
	
	void Center(BOOL bCenter = TRUE);
	
private:
	BOOL subclassed;
	int curStateInd;
	UINT states[_CBSTATEMAX_];
	CBitmap *pictures[_CBSTATEMAX_];
	UINT numStates;
	BOOL center;
	
	void DoAddState(UINT, UINT);  

// Implementation
public:
	virtual ~CBStateButton();

	// Generated message map functions
protected:
	virtual void DrawItem(LPDRAWITEMSTRUCT lpDIS);
};

/////////////////////////////////////////////////////////////////////////////
