"""
t3FNSD.py

Provides a class representing a function set dependency list block in a t3
image file.
"""

import struct
from t3Block import *

class FNSD_Block(Block):
	"""
	The fuction set dependency list block. There must be only one such block
	in an image file.
	"""
	name = "Function Set Dependency List Block"

	def __init__(self, datastream, image, attribs):
		Block.__init__(self, datastream, image, attribs)
		self.read_block()
		
	def read_block(self):
		"""
		Reads the data included in the block.
		"""
		n = struct.unpack("<H", self.datastream.read(2))[0]
		entries = []
		for i in xrange(n):
			namelen = struct.unpack("<B", self.datastream.read(1))[0]
			entries.append(self.datastream.read(namelen))
		self.data["l_entries"] = entries

	def report_data(self):
		s = "name: " + str(self.data["l_entries"]) + "\n"
		return s