/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class GameState {
    public static final int TRUNCATE = 6;
    public static final int MAX_UNDO = 300;
    public static final int CONTINUOUS = -999;
    public static final int EXPIRED = 0;
    private String _version;
    private int _flags;
    private String _timestamp;
    private Hashtable _vocab = new Hashtable(200);
    private Hashtable _compounds = new Hashtable(20);
    private Hashtable _specwords = new Hashtable(10);
    private Hashtable _fmtstrs = new Hashtable(10);
    private Hashtable _inheritance = new Hashtable(200);
    private Hashtable _objects = new Hashtable(200);
    private int _last_object = 0;
    private int[] _required_objects;
    private int _preinit;
    private Vector _daemons = new Vector(10);
    private TObject _parser_me = null;
    private TObject[] _singular_pronouns = new TObject[3];
    private TObject[] _plural_pronoun = null;
    private TObject[] _command_objects = new TObject[5];
    private ObjectMatch[] _command_matches = new ObjectMatch[2];
    private Vector[] _rex_groups = null;
    private Vector _undo_records = null;
    private Vector _restart_vocab_records = new Vector();
    private Hashtable _restart_prop_records = new Hashtable();

    public void set_version(String string) {
        this._version = string;
    }

    public void set_flags(int n) {
        this._flags = n;
    }

    public void set_timestamp(String string) {
        this._timestamp = string;
    }

    public void init() throws HaltTurnException {
        Object object;
        this._command_objects[0] = this._parser_me = this.lookup_required_object(0);
        if (!this._specwords.containsKey(",")) {
            this._specwords.put(",", ",");
        }
        if (!this._specwords.containsKey(":")) {
            this._specwords.put(":", ",");
        }
        if (!this._specwords.containsKey(".")) {
            this._specwords.put(".", ".");
        }
        if (!this._specwords.containsKey("!")) {
            this._specwords.put("!", ".");
        }
        if (!this._specwords.containsKey("?")) {
            this._specwords.put("?", ".");
        }
        if (!this._specwords.containsKey(";")) {
            this._specwords.put(";", ".");
        }
        Enumeration<Object> enumeration = this._vocab.elements();
        while (enumeration.hasMoreElements()) {
            object = (VocabWord[])enumeration.nextElement();
            for (int i = 0; i < ((VocabWord[])object).length; ++i) {
                ((VocabWord)object[i]).set_specword(this.lookup_specword(((VocabWord)object[i]).get_word()));
            }
        }
        enumeration = this._objects.keys();
        object = this._objects.elements();
        while (object.hasMoreElements()) {
            Object object2;
            TObject tObject = (TObject)object.nextElement();
            if (!tObject.is_object() || tObject.is_class()) continue;
            TValue tValue = tObject.lookup_property(13);
            if (tValue != null && tValue.get_type() == 2) {
                object2 = this.lookup_object(tValue.get_object());
                TValue tValue2 = ((TObject)object2).lookup_property(17, false);
                Vector vector = null;
                if (tValue2 == null || tValue2.get_type() == 14) {
                    vector = new Vector();
                    ((TObject)object2).set_property(17, new TValue(7, vector));
                } else {
                    vector = tValue2.get_list();
                }
                vector.addElement(new TValue(2, tObject.get_id()));
            }
            if ((object2 = tObject.lookup_property(17, false)) == null || ((TValue)object2).get_type() != 14) continue;
            tObject.set_property(17, new TValue(7, new Vector()));
        }
    }

    public void add_vocab(int n, int n2, int n3, String string, String string2) throws HaltTurnException {
        String string3 = string.length() > 6 ? string.substring(0, 6) : string;
        VocabWord[] vocabWordArray = (VocabWord[])this._vocab.get(string3);
        for (int i = 0; vocabWordArray != null && i < vocabWordArray.length; ++i) {
            if (!vocabWordArray[i].get_word().equals(string)) continue;
            this.lookup_object(n).add_vocab(vocabWordArray[i]);
            vocabWordArray[i].add_obj(string2, n, n2);
            return;
        }
        if (vocabWordArray == null) {
            vocabWordArray = new VocabWord[1];
        } else {
            VocabWord[] vocabWordArray2 = new VocabWord[vocabWordArray.length + 1];
            System.arraycopy(vocabWordArray, 0, vocabWordArray2, 0, vocabWordArray.length);
            vocabWordArray = vocabWordArray2;
        }
        vocabWordArray[vocabWordArray.length - 1] = new VocabWord(string, string2, n, n2);
        vocabWordArray[vocabWordArray.length - 1].set_specword(this.lookup_specword(string));
        this.lookup_object(n).add_vocab(vocabWordArray[vocabWordArray.length - 1]);
        this._vocab.put(string3, vocabWordArray);
    }

    public void del_vocab(int n, int n2, String string, String string2) throws HaltTurnException {
        String string3 = string.length() > 6 ? string.substring(0, 6) : string;
        VocabWord[] vocabWordArray = (VocabWord[])this._vocab.get(string3);
        for (int i = 0; vocabWordArray != null && i < vocabWordArray.length; ++i) {
            if (!vocabWordArray[i].get_word().equals(string)) continue;
            vocabWordArray[i].remove_obj(string2, n, n2);
            this.lookup_object(n).rem_vocab(vocabWordArray[i]);
            break;
        }
    }

    public VocabWord lookup_vocab(String string) {
        String string2 = string.length() > 6 ? string.substring(0, 6) : string;
        VocabWord[] vocabWordArray = (VocabWord[])this._vocab.get(string2);
        VocabWord vocabWord = null;
        int n = 0;
        for (int i = 0; vocabWordArray != null && i < vocabWordArray.length; ++i) {
            if (!vocabWordArray[i].get_word().startsWith(string)) continue;
            if (vocabWordArray[i].get_word().equals(string)) {
                return vocabWordArray[i];
            }
            if (++n == 1) {
                vocabWord = vocabWordArray[i];
                continue;
            }
            if (n == 2) {
                vocabWord = vocabWord.do_clone();
                vocabWord.set_word(string);
                vocabWord.merge(vocabWordArray[i]);
                vocabWord.truncated(true);
                continue;
            }
            vocabWord.merge(vocabWordArray[i]);
        }
        if (vocabWord == null) {
            vocabWord = new VocabWord(string, -1);
            vocabWord.set_specword(this.lookup_specword(string));
        }
        return vocabWord;
    }

    public void add_compound_word(String string, String string2, String string3) {
        this._compounds.put(string + " " + string2, string3);
    }

    public String lookup_compound_word(String string, String string2) {
        return (String)this._compounds.get(string + " " + string2);
    }

    public void add_specword(char c, String string) {
        this._specwords.put(string, String.valueOf(c));
    }

    public String lookup_specword(String string) {
        return (String)this._specwords.get(string);
    }

    public void add_inheritance(int n, int n2, int n3, int n4, int[] nArray) {
        int[] nArray2 = new int[nArray.length + 3];
        nArray2[0] = n2;
        nArray2[1] = n3;
        nArray2[2] = n4;
        System.arraycopy(nArray, 0, nArray2, 3, nArray.length);
        this._inheritance.put(new Integer(n), nArray2);
    }

    public void set_required(int[] nArray) {
        this._required_objects = nArray;
    }

    public void add_fmtstr(String string, int n) {
        this._fmtstrs.put(string, new Integer(n));
    }

    public int lookup_fmtstr(String string) {
        Integer n = (Integer)this._fmtstrs.get(string);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public void add_function_object(int n, byte[] byArray) {
        if (this._last_object < n) {
            this._last_object = n;
        }
        this._objects.put(new Integer(n), new TObject(n, byArray));
    }

    public void add_object_object(int n, int n2, int[] nArray, TProperty[] tPropertyArray) {
        if (this._last_object < n) {
            this._last_object = n;
        }
        this._objects.put(new Integer(n), new TObject(n, n2, nArray, tPropertyArray));
    }

    public TObject lookup_object(int n) throws HaltTurnException {
        return this.lookup_object(n, true);
    }

    public TObject lookup_object(int n, boolean bl) throws HaltTurnException {
        TObject tObject = (TObject)this._objects.get(new Integer(n));
        if (tObject == null && bl) {
            Jetty.out.print_error("Unknown/deleted object referenced", 1);
            throw new HaltTurnException(-5);
        }
        return tObject;
    }

    public TObject lookup_required_object(int n) {
        return (TObject)this._objects.get(new Integer(this._required_objects[n]));
    }

    public int get_last_object() {
        return this._last_object;
    }

    public TValue create_obj(TObject tObject) throws ParseException, ReparseException, HaltTurnException, GameOverException {
        int n = ++this._last_object;
        int n2 = 22;
        TProperty[] tPropertyArray = new TProperty[]{};
        int[] nArray = new int[]{tObject.get_id()};
        TObject tObject2 = new TObject(n, n2, nArray, tPropertyArray);
        this._objects.put(new Integer(tObject2.get_id()), tObject2);
        Jetty.out.print_error("dynamically creating object of class=" + nArray[0], 2);
        tObject2.set_property(17, new TValue(7, new Vector()));
        tObject2.eval_property(39, TObject.arg_array());
        this.copy_vocab(tObject, tObject2);
        this.save_newobj_undo(tObject2);
        return new TValue(2, tObject2.get_id());
    }

    private void copy_vocab(TObject tObject, TObject tObject2) {
        Vector vector = tObject.get_vocab();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            VocabWord vocabWord = (VocabWord)vector.elementAt(i);
            if (vocabWord.get_object(tObject.get_id(), vector2, vector3)) {
                tObject2.add_vocab(vocabWord);
                for (int j = 0; j < vector2.size(); ++j) {
                    int n = (Integer)vector2.elementAt(j);
                    Jetty.out.print_error("adding vocab=" + vocabWord.get_word() + " type=" + n, 2);
                    vocabWord.add_obj((String)vector3.elementAt(j), tObject2.get_id(), n);
                }
            } else {
                Jetty.out.print_error("Vocab word '" + vocabWord.get_word() + "' not found in copy=" + tObject.get_id(), 1);
            }
            vector2.removeAllElements();
            vector3.removeAllElements();
        }
    }

    public void delete_obj(TObject tObject) throws ParseException, ReparseException, HaltTurnException, GameOverException {
        this.delete_obj(tObject, true);
    }

    public void delete_obj(TObject tObject, boolean bl) throws ParseException, ReparseException, HaltTurnException, GameOverException {
        int n;
        if (bl) {
            tObject.eval_property(40, TObject.arg_array());
        }
        for (n = 0; n < this._singular_pronouns.length; ++n) {
            if (this._singular_pronouns[n] != tObject) continue;
            this._singular_pronouns[n] = null;
        }
        if (this._plural_pronoun != null) {
            for (n = 0; n < this._plural_pronoun.length; ++n) {
                if (this._plural_pronoun[n] != tObject) continue;
                this._plural_pronoun = null;
                break;
            }
        }
        for (n = 0; n < this._command_objects.length; ++n) {
            if (this._command_objects[n] != tObject) continue;
            this._command_objects[1] = null;
            this._command_objects[0] = null;
            break;
        }
        Vector vector = tObject.get_vocab();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            VocabWord vocabWord = (VocabWord)vector.elementAt(i);
            if (vocabWord.get_object(tObject.get_id(), vector2, vector3)) {
                for (int j = 0; j < vector2.size(); ++j) {
                    vocabWord.remove_obj((String)vector3.elementAt(j), tObject.get_id(), (Integer)vector2.elementAt(j));
                }
            } else {
                Jetty.out.print_error("Vocab word '" + vocabWord.get_word() + "' not found in obj=" + tObject.get_id(), 1);
            }
            vector2.removeAllElements();
            vector3.removeAllElements();
        }
        this._objects.remove(new Integer(tObject.get_id()));
        if (bl) {
            this.save_delobj_undo(tObject);
        }
    }

    public TObject lookup_it(int n) {
        if (n == 6) {
            return this._singular_pronouns[0];
        }
        if (n == 7) {
            return this._singular_pronouns[1];
        }
        if (n == 8) {
            return this._singular_pronouns[2];
        }
        Jetty.out.print_error("lookup_it called with which=" + n, 1);
        return null;
    }

    public void set_it(int n, TObject tObject) {
        if (tObject != null && (tObject == this.lookup_required_object(3) || tObject == this.lookup_required_object(2))) {
            tObject = null;
        }
        if (n == 6) {
            this._singular_pronouns[0] = tObject;
        } else if (n == 7) {
            this._singular_pronouns[1] = tObject;
        } else if (n == 8) {
            this._singular_pronouns[2] = tObject;
        } else {
            Jetty.out.print_error("set_it called with which=" + n, 1);
        }
    }

    public TObject[] lookup_them() {
        return this._plural_pronoun;
    }

    public void set_them(TObject[] tObjectArray) {
        this._plural_pronoun = tObjectArray;
    }

    public TObject get_command_object(int n) {
        if (n <= 0 || n > this._command_objects.length) {
            Jetty.out.print_error("get_command_object called with which=" + n, 1);
            return null;
        }
        return this._command_objects[n - 1];
    }

    public void set_command_object(int n, TObject tObject) {
        if (n <= 0 || n > this._command_objects.length) {
            Jetty.out.print_error("set_command_object called with which=" + n, 1);
            return;
        }
        this._command_objects[n - 1] = tObject;
    }

    public TObject get_actor() {
        return this.get_command_object(1);
    }

    public void set_actor(TObject tObject) {
        this.set_command_object(1, tObject);
    }

    public ObjectMatch get_command_match(int n) {
        if (n <= 0 || n > this._command_matches.length) {
            Jetty.out.print_error("get_command_match called with which=" + n, 1);
            return null;
        }
        return this._command_matches[n - 1];
    }

    public void set_command_match(int n, ObjectMatch objectMatch) {
        if (n <= 0 || n > this._command_matches.length) {
            Jetty.out.print_error("set_command_match called with which=" + n, 1);
            return;
        }
        this._command_matches[n - 1] = objectMatch;
    }

    public Vector[] get_rex_groups() {
        return this._rex_groups;
    }

    public void set_rex_groups(Vector[] vectorArray) {
        this._rex_groups = vectorArray;
    }

    public void add_daemon(int n, int n2, TValue tValue, int n3) {
        Daemon daemon = new Daemon(n, n2, tValue, n3);
        this._daemons.addElement(daemon);
        this.save_setdaemon_undo(daemon);
    }

    public void remove_daemon(int n, int n2, TValue tValue) {
        for (int i = 0; i < this._daemons.size(); ++i) {
            Daemon daemon = (Daemon)this._daemons.elementAt(i);
            if (daemon.object != n || daemon.property != n2 || !(tValue == null ? daemon.value == null : tValue.equals(daemon.value))) continue;
            this.save_remdaemon_undo(daemon);
            this._daemons.removeElementAt(i--);
        }
    }

    public int lookup_fuse(int n, int n2, TValue tValue) {
        for (int i = 0; i < this._daemons.size(); ++i) {
            Daemon daemon = (Daemon)this._daemons.elementAt(i);
            if (daemon.object != n || (n2 != -1 || !daemon.value.equals(tValue)) && (n2 == -1 || daemon.property != n2)) continue;
            return daemon.time == -999 ? -1 : daemon.time;
        }
        return -1;
    }

    public void burn_fuses(boolean bl) throws ParseException, ReparseException, HaltTurnException, GameOverException {
        for (int i = 0; i < this._daemons.size(); ++i) {
            Daemon daemon = (Daemon)this._daemons.elementAt(i);
            if (daemon.time == -999 || daemon.time == 0) continue;
            this.save_burn_undo(daemon, daemon.time);
            if (--daemon.time != 0) continue;
            daemon.time = 0;
        }
        if (bl) {
            this.run_daemons_and_fuses(false, true);
        }
    }

    public void run_daemons_and_fuses(boolean bl, boolean bl2) throws ParseException, ReparseException, HaltTurnException, GameOverException {
        Vector vector = (Vector)this._daemons.clone();
        for (int i = 0; i < vector.size(); ++i) {
            Daemon daemon = (Daemon)vector.elementAt(i);
            if ((daemon.time != -999 || !bl) && (daemon.time != 0 || !bl2)) continue;
            if (daemon.time == 0) {
                this._daemons.removeElement(daemon);
            }
            TObject tObject = this.lookup_object(daemon.object);
            if (daemon.property == -1) {
                Jetty.runner.run(tObject.get_data(), TObject.arg_array(daemon.value), tObject);
                continue;
            }
            tObject.eval_property(daemon.property, TObject.arg_array());
        }
    }

    public void set_parser_me(TObject tObject) {
        this._parser_me = tObject;
    }

    public TObject get_parser_me() {
        return this._parser_me;
    }

    public void set_preinit(int n) {
        this._preinit = n;
    }

    public TObject get_preinit() {
        return (TObject)this._objects.get(new Integer(this._preinit));
    }

    public boolean run_preinit() {
        return (this._flags & 4) != 0;
    }

    public boolean do_undo() throws ParseException, ReparseException, HaltTurnException, GameOverException {
        if (this._undo_records.size() == 0) {
            return false;
        }
        block0: while (this._undo_records.size() > 0) {
            UndoRecord undoRecord = (UndoRecord)this._undo_records.elementAt(this._undo_records.size() - 1);
            this._undo_records.removeElementAt(this._undo_records.size() - 1);
            if (undoRecord.type == 0) break;
            if (undoRecord.type == 1) {
                if (undoRecord.value == null) {
                    undoRecord.obj.del_property(undoRecord.num);
                    continue;
                }
                undoRecord.obj.set_property(undoRecord.num, undoRecord.value, false);
                continue;
            }
            if (undoRecord.type == 2) {
                undoRecord.daemon.time = undoRecord.num;
                for (int i = 0; i < this._daemons.size(); ++i) {
                    if (this._daemons.elementAt(i) == undoRecord.daemon) continue block0;
                }
                this._daemons.addElement(undoRecord.daemon);
                continue;
            }
            if (undoRecord.type == 3) {
                for (int i = 0; i < this._daemons.size(); ++i) {
                    if (this._daemons.elementAt(i) != undoRecord.daemon) continue;
                    this._daemons.removeElementAt(i--);
                }
                continue;
            }
            if (undoRecord.type == 4) {
                this._daemons.addElement(undoRecord.daemon);
                continue;
            }
            if (undoRecord.type == 5) {
                this.delete_obj(undoRecord.obj, false);
                continue;
            }
            if (undoRecord.type == 6) {
                this._objects.put(new Integer(undoRecord.obj.get_id()), undoRecord.obj);
                TObject tObject = this.lookup_object(undoRecord.obj.get_superclasses()[0]);
                this.copy_vocab(tObject, undoRecord.obj);
                continue;
            }
            if (undoRecord.type == 7) {
                this._parser_me = undoRecord.obj;
                continue;
            }
            if (undoRecord.type == 8 || undoRecord.type == 9) {
                String string = undoRecord.word;
                String string2 = null;
                int n = string.indexOf(32);
                if (n != -1) {
                    string2 = string.substring(n + 1);
                    string = string.substring(0, n);
                }
                if (undoRecord.type == 8) {
                    this.del_vocab(undoRecord.obj.get_id(), undoRecord.num, string, string2);
                    continue;
                }
                this.add_vocab(undoRecord.obj.get_id(), undoRecord.num, 0, string, string2);
                continue;
            }
            Jetty.out.print_error("Unknown undo record type found: " + undoRecord.type, 1);
        }
        return true;
    }

    public void set_undo_savepoint() {
        if (this._undo_records == null) {
            this._undo_records = new Vector(300);
        } else {
            this.add_undo(new UndoRecord(0));
        }
    }

    public void save_prop_undo(TObject tObject, int n, TValue tValue) {
        UndoRecord undoRecord = new UndoRecord(1);
        undoRecord.obj = tObject;
        undoRecord.num = n;
        undoRecord.value = tValue == null ? null : tValue.do_clone();
        this.add_undo(undoRecord);
    }

    private void save_burn_undo(Daemon daemon, int n) {
        UndoRecord undoRecord = new UndoRecord(2);
        undoRecord.daemon = daemon;
        undoRecord.num = n;
        this.add_undo(undoRecord);
    }

    private void save_setdaemon_undo(Daemon daemon) {
        UndoRecord undoRecord = new UndoRecord(3);
        undoRecord.daemon = daemon;
        this.add_undo(undoRecord);
    }

    private void save_remdaemon_undo(Daemon daemon) {
        UndoRecord undoRecord = new UndoRecord(4);
        undoRecord.daemon = daemon;
        this.add_undo(undoRecord);
    }

    private void save_newobj_undo(TObject tObject) {
        UndoRecord undoRecord = new UndoRecord(5);
        undoRecord.obj = tObject;
        this.add_undo(undoRecord);
    }

    private void save_delobj_undo(TObject tObject) {
        UndoRecord undoRecord = new UndoRecord(6);
        undoRecord.obj = tObject;
        this.add_undo(undoRecord);
    }

    public void save_setme_undo(TObject tObject) {
        UndoRecord undoRecord = new UndoRecord(7);
        undoRecord.obj = tObject;
        this.add_undo(undoRecord);
    }

    public void save_addword_undo(int n, int n2, String string) throws HaltTurnException {
        UndoRecord undoRecord = new UndoRecord(8);
        undoRecord.obj = this.lookup_object(n);
        undoRecord.num = n2;
        undoRecord.word = string;
        this.add_undo(undoRecord);
    }

    public void save_delword_undo(int n, int n2, String string) throws HaltTurnException {
        UndoRecord undoRecord = new UndoRecord(9);
        undoRecord.obj = this.lookup_object(n);
        undoRecord.num = n2;
        undoRecord.word = string;
        this.add_undo(undoRecord);
    }

    public void do_restart() throws HaltTurnException, ParseException, ReparseException, GameOverException {
        int n;
        int n2;
        Object object;
        Object object2;
        Object object3;
        for (int i = this._restart_vocab_records.size() - 1; i >= 0; --i) {
            object3 = (UndoRecord)this._restart_vocab_records.elementAt(i);
            if (((UndoRecord)object3).type != 8 && ((UndoRecord)object3).type != 9) continue;
            object2 = ((UndoRecord)object3).word;
            object = null;
            n2 = ((String)object2).indexOf(32);
            if (n2 != -1) {
                object = ((String)object2).substring(n2 + 1);
                object2 = ((String)object2).substring(0, n2);
            }
            if (((UndoRecord)object3).type == 8) {
                this.del_vocab(((UndoRecord)object3).obj.get_id(), ((UndoRecord)object3).num, (String)object2, (String)object);
                continue;
            }
            this.add_vocab(((UndoRecord)object3).obj.get_id(), ((UndoRecord)object3).num, 0, (String)object2, (String)object);
        }
        Vector<Object> vector = new Vector<Object>();
        object3 = this._restart_prop_records.keys();
        while (object3.hasMoreElements()) {
            object2 = (TObject)object3.nextElement();
            object = (TProperty[])this._restart_prop_records.get(object2);
            for (n2 = 0; n2 < ((TProperty[])object).length; ++n2) {
                ((TObject)object2).set_property(object[n2].id, object[n2].value, false);
            }
            if (!((TObject)object2).is_dynamic()) continue;
            vector.addElement(object2);
        }
        for (n = 0; n < vector.size(); ++n) {
            this.delete_obj((TObject)vector.elementAt(n), false);
        }
        this._daemons.removeAllElements();
        this._parser_me = this.lookup_required_object(0);
        for (n = 0; n < this._singular_pronouns.length; ++n) {
            this._singular_pronouns[n] = null;
        }
        this._plural_pronoun = null;
        for (n = 0; n < this._command_objects.length; ++n) {
            this._command_objects[n] = null;
        }
        this._command_objects[0] = this._parser_me;
        for (n = 0; n < this._command_matches.length; ++n) {
            this._command_matches[n] = null;
        }
        this._undo_records = null;
        this._restart_vocab_records.removeAllElements();
        if (this._restart_prop_records.size() > 0) {
            this._restart_prop_records = new Hashtable(this._restart_prop_records.size());
        }
    }

    private void save_prop_restart(TObject tObject, int n, TValue tValue) {
        TProperty[] tPropertyArray = (TProperty[])this._restart_prop_records.get(tObject);
        for (int i = 0; tPropertyArray != null && i < tPropertyArray.length; ++i) {
            if (tPropertyArray[i].id != n) continue;
            return;
        }
        if (tPropertyArray == null) {
            tPropertyArray = new TProperty[1];
        } else {
            TProperty[] tPropertyArray2 = new TProperty[tPropertyArray.length + 1];
            System.arraycopy(tPropertyArray, 0, tPropertyArray2, 0, tPropertyArray.length);
            tPropertyArray = tPropertyArray2;
        }
        tPropertyArray[tPropertyArray.length - 1] = new TProperty(n, tValue);
        this._restart_prop_records.put(tObject, tPropertyArray);
    }

    private void add_undo(UndoRecord undoRecord) {
        if (this._undo_records != null) {
            this._undo_records.addElement(undoRecord);
            if (this._undo_records.size() > 300) {
                this._undo_records.removeElementAt(0);
            }
            if (undoRecord.type == 1) {
                this.save_prop_restart(undoRecord.obj, undoRecord.num, undoRecord.value);
            } else if (undoRecord.type == 8 || undoRecord.type == 9) {
                this._restart_vocab_records.addElement(undoRecord);
            }
        }
    }

    private static class UndoRecord {
        public static final int SAVE_POINT = 0;
        public static final int PROPERTY = 1;
        public static final int FUSE_BURN = 2;
        public static final int SET_DAEMON = 3;
        public static final int REM_DAEMON = 4;
        public static final int NEW_OBJECT = 5;
        public static final int DEL_OBJECT = 6;
        public static final int SET_ME = 7;
        public static final int ADD_WORD = 8;
        public static final int DEL_WORD = 9;
        public int type;
        public TObject obj;
        public int num;
        public Daemon daemon;
        public TValue value;
        public String word;

        public UndoRecord(int n) {
            this.type = n;
        }
    }

    private static class Daemon {
        public int object;
        public int property;
        public TValue value;
        public int time;

        public boolean equals(Object object) {
            if (!(object instanceof Daemon)) {
                return false;
            }
            Daemon daemon = (Daemon)object;
            return this.object == daemon.object && this.property == daemon.property && (this.value == null ? daemon.value == null : this.value.equals(daemon.value));
        }

        public Daemon(int n, int n2, TValue tValue, int n3) {
            this.object = n;
            this.property = n2;
            this.value = tValue;
            this.time = n3;
        }
    }
}

