/* Copyright (c) 1999, 2000 by Kevin Forchione.  All Rights Reserved. */
/*
 *  TADS ADV.T/STD.T LIBRARY EXTENSION
 *  OBJECTREE.T				
 *  version 1.0
 *
 *      Provides a few basic definitions for playing with an object
 *      tree.
 *
 *----------------------------------------------------------------------
 *  REQUIREMENTS
 *
 *      + HTML TADS 2.2.6 or later
 *      + Should be #included after ADV.T and STD.T 
 *
 *----------------------------------------------------------------------
 *  IMPORTANT LIBRARY INTERFACE AND MODIFICATION
 *
 *      None.
 *
 *----------------------------------------------------------------------
 *  COPYRIGHT NOTICE
 *
 *  	You may modify and use this file in any way you want, provided that
 *		if you redistribute modified copies of this file in source form, the
 *   	copies must include the original copyright notice (including this
 *   	paragraph), and must be clearly marked as modified from the original
 *   	version.
 *
 *------------------------------------------------------------------------------
 *  REVISION HISTORY
 *
 *		07-May-99:	Creation.
 */

parent: function;
child: function;
sibling: function;
ancestor: function;
descendant: function;

parent: function(obj)
{
    return obj.location;
}

child: function(obj)
{
    return obj.contents;
}

sibling: function(obj)
{
    local list := [], parent := obj.location;
    
    if (parent)
    {
        list := parent.contents - obj;
    }
    return list;
}

ancestor: function(obj)
{
    local list :=[], parent := obj.location;
    
    while(parent)
    {
        list += parent;
        parent := parent.location;
    }
    return list;
}

descendant: function(obj)
{
    local ret := [];
    local i, lst, len;
    
    if (obj = nil)
        return ret;

    lst := obj.contents;
    len := length(lst);
    ret += lst;
    for (i := 1 ; i <= len ; ++i)
    {
        ret += descendant(lst[i]);
    }
    return ret;
}
