/* 
 * example.c --
 *
 *	This file is an example of a Tcl dynamically loadable extension.
 *
 * Copyright (c) 1996 by Sun Microsystems, Inc.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * SCCS: @(#) example.c 1.4 96/04/26 10:42:55
 */

#include <tcl.h>
#include "example.h"


/*
 * Declarations for functions defined in this file.
 */

static int		ExampleCmd _ANSI_ARGS_((ClientData clientData,
			    Tcl_Interp *interp, int argc, char **argv));


/*
 *----------------------------------------------------------------------
 *
 * DllEntryPoint --
 *
 *	This wrapper function is used by Windows to invoke the
 *	initialization code for the DLL.  If we are compiling
 *	with Visual C++, this routine will be renamed to DllMain.
 *	routine.
 *
 * Results:
 *	Returns TRUE;
 *
 * Side effects:
 *	None.
 *
 *----------------------------------------------------------------------
 */

#ifdef __WIN32__
BOOL APIENTRY
DllEntryPoint(hInst, reason, reserved)
    HINSTANCE hInst;		/* Library instance handle. */
    DWORD reason;		/* Reason this function is being called. */
    LPVOID reserved;		/* Not used. */
{
    return TRUE;
}
#endif

/*
 *----------------------------------------------------------------------
 *
 * Example_Init --
 *
 *	This procedure initializes the example command.
 *
 * Results:
 *	A standard Tcl result.
 *
 * Side effects:
 *	None.
 *
 *----------------------------------------------------------------------
 */

EXPORT(int,Example_Init)(interp)
    Tcl_Interp *interp;
{
    Tcl_CreateCommand(interp, "example", ExampleCmd, NULL, NULL);
    return Tcl_PkgProvide(interp, "example", "1.0");
}

/*
 *----------------------------------------------------------------------
 *
 * Example_SafeInit --
 *
 *	This procedure initializes the example command for a safe 
 *      interpreter.  You would leave out of this procedure any commands
 *      you deemed unsafe.
 *
 * Results:
 *	A standard Tcl result.
 *
 * Side effects:
 *	None.
 *
 *----------------------------------------------------------------------
 */

EXPORT(int,Example_SafeInit)(interp)
    Tcl_Interp *interp;
{
    Tcl_CreateCommand(interp, "example", ExampleCmd, NULL, NULL);
    return Tcl_PkgProvide(interp, "example", "1.0");
}

/*
 *----------------------------------------------------------------------
 *
 * ExampleCmd --
 *
 *	This function implements the Tcl "example" command.
 *
 * Results:
 *	A standard Tcl result.
 *
 * Side effects:
 *	None.
 *
 *----------------------------------------------------------------------
 */

static int
ExampleCmd(clientData, interp, argc, argv)
    ClientData clientData;
    Tcl_Interp *interp;
    int argc;
    char **argv;
{
    /*
     * Note that we must be very careful not to use TCL_DYNAMIC here
     * if we are compiling with a compiler other than Borland C++ 4.5
     * because the malloc/free routines are different.  Instead, we
     * should explicitly set the free proc to point to the free()
     * supplied with the run-time library used by the extension.
     */

    Tcl_SetResult(interp, "example is not implemented yet", TCL_STATIC);
    return TCL_OK;
}
