(*
$File: Compiler/RUNTIME.sml $
$Date: 1992/09/17 14:18:02 $
$Revision: 1.1 $
$Locker:  $
*)

(* This is rather complicated, since the types for object and DEnv (runtime
   environment) are self-referential. Eventually, the function objects will
   have had their closures lifted, so they won't contain environments, and
   this will all be much more straightforward. *)

(*$OBJECTS*)
signature OBJECTS =
  sig
    type lvar
    type LambdaExp			(* for building closures. *)
    type DEnv				(* lvar->object environment. *)
    type object

    val void: object

    val integer: int -> object
    val deInteger: object -> int

    val real: real -> object
    val deReal: object -> real

    val string: string -> object
    val deString: object -> string

    val closure:
	  {arg: lvar, body: LambdaExp, bodyEnv: DEnv} -> object
	(* the recVE part is created empty. *)

    val deClosure:
      object -> {arg: lvar, body: LambdaExp, bodyEnv: DEnv, recEnv: DEnv}

    val vector: object list -> object
    val select: int * object -> object

    val Ref: object -> object
    val deRef: object -> object

    val equal: object * object -> bool

    type StringTree
    val layoutObject: object -> StringTree
  end;

(*$DYNAMIC_ENV*)
signature DYNAMIC_ENV =
  sig
    type DEnv
    type lvar
    type object

    val emptyDEnv: DEnv
    val declare: (lvar * object * DEnv) -> DEnv
    val plus: DEnv * DEnv -> DEnv
    val REC: DEnv -> DEnv		(* Semantics V3, p48 *)
    val lookup: DEnv -> lvar -> object

    type StringTree
    val layoutDEnv: DEnv -> StringTree
  end;

(*$RUNTIME: OBJECTS DYNAMIC_ENV*)
(* Runtime objects, modelled by the lambda interpreter, and runtime
   environments. The two sub-structures contain mutually recursive types,
   so neither can be built in isolation. *)

signature RUNTIME =
  sig
    structure Objects: OBJECTS
    structure DynamicEnv: DYNAMIC_ENV
      sharing type Objects.DEnv = DynamicEnv.DEnv
	  and type Objects.lvar = DynamicEnv.lvar
	  and type Objects.object = DynamicEnv.object
  end;
